function md=tres(md,string)
%TRANSFERVEL transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%
%    Example: md=tres(md,'diagnostic');
%             md=tres(md,'control');

if strcmpi(string,'diagnostic'),
	md.vx=md.results.diagnostic.vx;
	md.vy=md.results.diagnostic.vy;
	md.vel=md.results.diagnostic.vel;
	md.pressure=md.results.diagnostic.pressure;
	if md.numrifts,
		md.riftproperties=md.results.diagnostic.riftproperties;
	end
elseif strcmpi(string,'thermalstatic'),
	md.vx=md.results.thermalstatic.vx;
	md.vy=md.results.thermalstatic.vy;
	md.vel=md.results.thermalstatic.vel;
	md.pressure=md.results.thermalstatic.pressure;
	md.temperature=md.results.thermalstatic.temperature;
	md.melting=md.results.thermalstatic.melting;
elseif strcmpi(string,'thermal'),
	md.temperature=md.results.thermalstatic.temperature;
	md.melting=md.results.thermalstatic.melting;
else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
