function plot_riftfraction(md,options_structure,width,i);
%PLOT_RIFTRELVEL - plot rift fractions
%
%   Usage:
%      plot_riftfraction(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%units
if ~isnan(options_structure.unitmultiplier),
	md.x=md.x*options_structure.unitmultiplier;
	md.y=md.y*options_structure.unitmultiplier;
	md.z=md.z*options_structure.unitmultiplier;
end

for i=1:size(md.segments,1),
	h1=plot(md.x(md.segments(i,1:2)),md.y(md.segments(i,1:2)),'k.-');hold on;
end

%first, build a vector of fractions, over all grids. 
fractions=zeros(md.numberofgrids,1);

%plug riftproperties fractions:
fractions(md.riftinfo(:,1))=md.riftproperties;
fractions(md.riftinfo(:,2))=md.riftproperties;

%complete the tips.
for i=1:length(md.rifts), 
	tips=md.rifts(i).tips;
	fractions(tips)=1;
end

hold on;
for i=1:length(md.rifts), 
	segments=md.rifts(i).segments(:,1:2)';
	xc=md.x(segments(:));
	yc=md.y(segments(:));
	zc=fractions(segments(:));
	h2=patch('Xdata',xc,'Ydata',yc,'Zdata',zc,'Cdata',zc,'facecolor','none','edgecolor','flat');
end
legend([h1,h2],'mesh boundaries','rifts')

%apply options
if isnan(options_structure.title)
	options_structure.title='Rift relative velocities';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
