#!/bin/bash

echo "Downloading SeaRISE dataset - Antarctica"
$ISSM_DIR/scripts/DownloadExternalPackage2.py 'http://websrv.cs.umt.edu/isis/index.php/Present_Day_Antarctica/Antarctica_5km_withshelves_v0.75.nc' 'Antarctica_5km_withshelves_v0.75.nc'

echo "Downloading InSAR Antarctic velocities"
$ISSM_DIR/scripts/DownloadExternalPackage2.py 'ftp://sidads.colorado.edu/pub/DATASETS/nsidc0484_MEASURES_antarc_vel_V01/900m/antarctica_ice_velocity.nc' 'Antarctica_ice_velocity.nc' 

echo "Downloading PIG control model"
$ISSM_DIR/scripts/DownloadExternalPackage2.py 'http://issm.jpl.nasa.gov/files/workshop2014/PIG.Control_drag_default' 'PIG.Control_drag_default'

echo "Downloading PIG errors"
$ISSM_DIR/scripts/DownloadExternalPackage2.py 'http://issm.jpl.nasa.gov/files/workshop2014/CrossOvers2009.mat' 'CrossOvers2009.mat'

echo "Downloading SeaRISE dataset - Greenland"
$ISSM_DIR/scripts/DownloadExternalPackage2.py 'http://websrv.cs.umt.edu/isis/index.php/Present_Day_Greenland/Greenland_5km_dev1.2.nc' 'Greenland_5km_dev1.2.nc'

echo "Downloading Jason Box's SMB"
$ISSM_DIR/scripts/DownloadExternalPackage2.py 'http://issm.jpl.nasa.gov/files/workshop2014/Box_Greenland_SMB_monthly_1840-2012_5km_ver20140421.nc' 'Box_Greenland_SMB_monthly_1840-2012_5km_ver20140421.nc'

echo "Downloading IceBridge Jakobshavn bedrock"
$ISSM_DIR/scripts/DownloadExternalPackage2.py 'https://data.cresis.ku.edu/data/grids/old_versions/Jakobshavn_2008_2011_Composite.zip' 'Jakobshavn_2008_2011_Composite.zip'
