%SMBcomponents Class definition
%
%   Usage:
%      SMBcomponents=SMBcomponents();

classdef SMBcomponents
	properties (SetAccess=public) 
		accumulation = NaN;
		runoff = NaN;
		evaporation = NaN;
	end
	methods
		function obj = SMBcomponents(varargin) % {{{
			switch nargin
				case 0
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{

			self.accumulation=project3d(md,'vector',self.accumulation,'type','node');
			self.runoff=project3d(md,'vector',self.runoff,'type','node');
			self.evaporation=project3d(md,'vector',self.evaporation,'type','node');

		end % }}}
		function self = initialize(self,md) % {{{

			if isnan(self.accumulation)
				self.accumulation=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.accumulation specified: values set as zero');
			end
			if isnan(self.evaporation)
				self.evaporation=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.evaporation specified: values set as zero');
			end
			if isnan(self.runoff)
				self.runoff=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.runoff specified: values set as zero');
			end

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.accumulation','forcing',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.accumulation','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.runoff','forcing',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.runoff','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.evaporation','forcing',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.evaporation','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters (SMB=accumulation-runoff-evaporation) :'));
			fielddisplay(obj,'accumulation','accumulated snow [m/yr ice eq]');
			fielddisplay(obj,'runoff','amount of ice melt lost from the ice column [m/yr ice eq]');
			fielddisplay(obj,'evaporation','amount of ice lost to evaporative processes [m/yr ice eq]');
		end % }}}
		function marshall(obj,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBcomponentsEnum(),'format','Integer');
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','accumulation','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','runoff','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','evaporation','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1);
		end % }}}
	end
end
