from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from project3d import *
from WriteData import *

class SMBmeltcomponents(object):
	"""
	SMBmeltcomponents Class definition

	   Usage:
	      SMBmeltcomponents=SMBmeltcomponents();
	"""

	def __init__(self): # {{{
		self.accumulation = float('NaN')
		self.runoff = float('NaN')
		self.evaporation = float('NaN')
		#}}}
	def __repr__(self): # {{{
		string="   surface forcings parameters with melt (SMB=accumulation-evaporation-melt+refreeze) :"
		string="%s\n%s"%(string,fielddisplay(self,'accumulation','accumulated snow [m/yr ice eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'evaporation','mount of ice lost to evaporative processes [m/yr ice eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'melt','amount of ice melt in the ice column [m/yr ice eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'refreeze','amount of ice melt refrozen in the ice column [m/yr ice eq]'))
		return string
		#}}}
	def extrude(self,md): # {{{

		self.mass_balance=project3d(md,'vector',self.accumulation,'type','node');
		self.mass_balance=project3d(md,'vector',self.evaporation,'type','node');
		self.mass_balance=project3d(md,'vector',self.melt,'type','node');
		self.mass_balance=project3d(md,'vector',self.refreeze,'type','node');
		return self
	#}}}
	def initialize(self,md): # {{{

		if numpy.all(numpy.isnan(self.accumulation)):
			self.accumulation=numpy.zeros((md.mesh.numberofvertices,1))
			print "      no SMB.accumulation specified: values set as zero"

		if numpy.all(numpy.isnan(self.evaporation)):
			self.evaporation=numpy.zeros((md.mesh.numberofvertices,1))
			print "      no SMB.evaporation specified: values set as zero"

		if numpy.all(numpy.isnan(self.melt)):
			self.melt=numpy.zeros((md.mesh.numberofvertices,1))
			print "      no SMB.melt specified: values set as zero"

		if numpy.all(numpy.isnan(self.refreeze)):
			self.refreeze=numpy.zeros((md.mesh.numberofvertices,1))
			print "      no SMB.refreeze specified: values set as zero"

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.accumulation','forcing',1,'NaN',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.accumulation','size',[md.mesh.numberofvertices],'NaN',1)

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.melt','forcing',1,'NaN',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.melt','size',[md.mesh.numberofvertices],'NaN',1)

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.refreeze','forcing',1,'NaN',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.refreeze','size',[md.mesh.numberofvertices],'NaN',1)

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.evaporation','forcing',1,'NaN',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.evaporation','size',[md.mesh.numberofvertices],'NaN',1)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{

		yts=365.0*24.0*3600.0

		WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBEnum(),'format','Integer');
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','accumulation','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','evaporation','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','melt','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','refreeze','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
	# }}}
