/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.LinkedList;

public class PanelNode {
    private String data;
    private PanelNode parent;
    private LinkedList<PanelNode> children = new LinkedList();

    public PanelNode(String string) {
        this.data = string;
        this.parent = null;
    }

    public PanelNode(PanelNode panelNode) {
        this.data = panelNode.data;
        this.parent = panelNode.parent;
        this.children = new LinkedList<PanelNode>(panelNode.children);
    }

    public String getData() {
        return this.data;
    }

    public PanelNode getChild(String string) {
        for (PanelNode panelNode : this.children) {
            if (!panelNode.data.equals(string)) continue;
            return panelNode;
        }
        return null;
    }

    public PanelNode add(PanelNode panelNode) {
        panelNode.parent = this;
        this.children.add(panelNode);
        return this.children.getLast();
    }

    public PanelNode get(String string) {
        if (this.data.equals(string)) {
            return this;
        }
        for (PanelNode panelNode : this.children) {
            PanelNode panelNode2 = panelNode.get(string);
            if (panelNode2 == null) continue;
            return panelNode2;
        }
        return null;
    }

    public boolean remove(PanelNode panelNode) {
        return this.children.remove(panelNode);
    }

    public PanelNode getParent() {
        return this.parent;
    }

    public void getKeyList(LinkedList<String> linkedList) {
        if (this.data.indexOf(35) == -1 && this.data.indexOf(37) == -1) {
            linkedList.add(this.data);
        }
        for (PanelNode panelNode : this.children) {
            panelNode.getKeyList(linkedList);
        }
    }
}

