/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import main.GUI;
import org.w3c.dom.Element;

public class TextfieldPanel
extends ControlledPanel
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private String defaultText;
    protected JTextField textfield = new JTextField(10);

    public TextfieldPanel(Element element, ControlledPanel controlledPanel) {
        super(element, controlledPanel);
        this.textfield.setVisible(true);
        this.add((Component)this.textfield, "width 250:100:400, cell 1 0, growx, ay top, gaptop 3");
        this.textfield.addKeyListener(this);
        this.defaultText = "";
        if (element.hasAttribute("default")) {
            this.defaultText = element.getAttribute("default");
        }
        this.textfield.setText(this.defaultText);
        if (!this.optional) {
            this.textfield.setBackground(GUI.WARNING_BACKGROUND_COLOR);
        }
        this.checkBgColor();
        this.textfield.invalidate();
    }

    @Override
    public void close() {
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
        String string3 = (String)hashMap.get(this.hashKey);
        if (string3 != null) {
            this.textfield.setText(string3);
        }
        this.checkBgColor();
    }

    @Override
    public String getValue() {
        String string = this.textfield.getText();
        if (!this.isOptional() && string.equals("")) {
            JOptionPane.showMessageDialog(null, "No value was entered for " + this.getKey() + " (section '" + this.getSection().toUpperCase() + "')" + ".\nA value is required. Your .ini-file is probably incorrect.", "Problem when building .ini file", 2);
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.checkBgColor();
    }

    public void checkBgColor() {
        String string = this.textfield.getText();
        if (!this.optional) {
            if (string.length() > 0) {
                this.textfield.setBackground(GUI.NORMAL_BACKGROUND_COLOR);
            } else {
                this.textfield.setBackground(GUI.WARNING_BACKGROUND_COLOR);
            }
            this.textfield.invalidate();
        }
    }
}

