/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import main.GUIBuilder;
import main.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DuplicatorPanel
extends ControlledPanel
implements ActionListener {
    private static final long serialVersionUID = 6801877538909126920L;
    JButton addButton = new JButton("+");
    Element clone;
    JButton removeButton;

    public DuplicatorPanel(Element element, ControlledPanel controlledPanel) {
        super(element, controlledPanel);
        this.add((Component)this.addButton, "cell 1 0, split 2, grow");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("-");
        this.add((Component)this.removeButton, "cell 1 0, grow, wrap");
        this.removeButton.addActionListener(this);
        this.clone = (Element)element.cloneNode(true);
        this.clone.removeAttribute("counter");
        this.clone.setAttribute("counted", "true");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.remove();
        }
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
        if (string.indexOf(35) == -1) {
            ControlledPanel controlledPanel = this.add(true, hashMap, string, string2);
            controlledPanel.set(hashMap, string, string2);
        }
    }

    public ControlledPanel add() {
        return this.add(false, null, null, null);
    }

    public ControlledPanel add(boolean bl, HashMap hashMap, String string, String string2) {
        Element element = (Element)this.clone.cloneNode(true);
        int n = Integer.parseInt(this.element.getAttribute("counter"));
        this.element.setAttribute("counter", n + 1 + "");
        this.recursiveKeyReplace(element, n + "");
        this.element.appendChild(element);
        ControlledPanel controlledPanel = null;
        try {
            controlledPanel = ControlledPanel.createSingleParameterPanel(element, this);
            controlledPanel.setKey(controlledPanel.getKey());
            GUIBuilder.gui.addToTab(controlledPanel, this.section, this);
            controlledPanel.hold();
            GUIBuilder.control(controlledPanel);
            GUIBuilder.recursiveBuild(element, this, bl, hashMap, string, string2);
        }
        catch (GUIBuildException gUIBuildException) {
            gUIBuildException.printStackTrace();
        }
        this.invalidate();
        return controlledPanel;
    }

    @Override
    public void close() {
        boolean bl = true;
        while (bl = this.remove()) {
        }
    }

    @Override
    public String getValue() {
        return null;
    }

    public boolean remove() {
        int n = Integer.parseInt(this.element.getAttribute("counter")) - 1;
        String string = this.element.getAttribute("key").replace("#", n + "");
        Element element = XMLHelper.getCertainChildElement(this.element, "parameter", "key", string);
        if (element == null) {
            return false;
        }
        this.element.removeChild(element);
        this.element.setAttribute("counter", n + "");
        ControlledPanel controlledPanel = GUIBuilder.panelControl.get(this.section, string);
        if (controlledPanel != null) {
            controlledPanel.release();
            controlledPanel.close();
            try {
                if (!controlledPanel.isNeeded()) {
                    GUIBuilder.gui.removeFromTab(controlledPanel, this.section, this);
                }
            }
            catch (GUIBuildException gUIBuildException) {
                gUIBuildException.printStackTrace();
            }
        }
        this.invalidate();
        return true;
    }

    private void recursiveKeyReplace(Element element, String string) {
        if (element.hasAttribute("key")) {
            element.setAttribute("key", element.getAttribute("key").replaceAll("#", string));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            this.recursiveKeyReplace((Element)nodeList.item(i), string);
        }
    }
}

