/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.TextfieldPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.JFormattedTextField;
import org.w3c.dom.Element;

public class DecimalPanel
extends TextfieldPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1555742510677354674L;
    double defaultvalue;
    double maximumvalue;
    double minimumvalue;
    JFormattedTextField textfield;

    public DecimalPanel(Element element, ControlledPanel controlledPanel) {
        super(element, controlledPanel);
        this.remove(((TextfieldPanel)this).textfield);
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setGroupingUsed(false);
        this.textfield = new JFormattedTextField(decimalFormat);
        this.textfield.addActionListener(this);
        this.textfield.addFocusListener(this);
        this.add((Component)this.textfield, "cell 1 0, growx, ay top, gaptop 3");
        this.textfield.setVisible(true);
        this.invalidate();
        this.defaultvalue = 0.0;
        this.maximumvalue = Double.MAX_VALUE;
        this.minimumvalue = Double.MIN_VALUE;
        if (element.hasAttribute("minimum")) {
            this.minimumvalue = Double.parseDouble(element.getAttribute("minimum"));
        }
        if (element.hasAttribute("maximum")) {
            this.maximumvalue = Double.parseDouble(element.getAttribute("maximum"));
        }
        if (element.hasAttribute("default")) {
            this.defaultvalue = Double.parseDouble(element.getAttribute("default"));
        }
        this.setToDefaultValue();
    }

    private void setToDefaultValue() {
        this.textfield.setValue(new Double(this.defaultvalue));
        this.invalidate();
    }

    private void checkValue() {
        try {
            this.textfield.commitEdit();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        double d = ((Number)this.textfield.getValue()).doubleValue();
        if (d > this.maximumvalue) {
            this.textfield.setValue(new Double(this.maximumvalue));
        } else if (d < this.minimumvalue) {
            this.textfield.setValue(new Double(this.minimumvalue));
        }
    }

    @Override
    public String getValue() {
        return this.textfield.getValue().toString();
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
        String string3 = (String)hashMap.get(this.hashKey);
        if (string3 != null) {
            try {
                Double.parseDouble(string3);
                this.textfield.setText(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.checkValue();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.checkValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.checkValue();
    }
}

