/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.AlternativePanel;
import gui_elements.CheckBoxPanel;
import gui_elements.CombinedPanel;
import gui_elements.DecimalPanel;
import gui_elements.DuplicatorPanel;
import gui_elements.FramePanel;
import gui_elements.GUIBuildException;
import gui_elements.IntegerPanel;
import gui_elements.PathPanel;
import gui_elements.SelectorPanel;
import gui_elements.TextfieldPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.GUI;
import main.GUIBuilder;
import main.XMLHelper;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Element;

public abstract class ControlledPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int dependencies;
    protected JLabel jlabel;
    protected String section;
    protected String key;
    protected String label;
    protected String hashKey;
    protected Element element;
    protected boolean optional;
    protected String replace;
    protected int hierarchy;
    protected String helptext;
    protected JEditorPane help;

    public ControlledPanel(Element element, ControlledPanel controlledPanel) {
        this(element, controlledPanel, true);
    }

    public ControlledPanel(Element element, ControlledPanel controlledPanel, boolean bl) {
        this.initialize(element, controlledPanel);
        if (bl) {
            int n = 200;
            this.setLayout(new MigLayout("gapx 6, wrap 8, top, ins n 5 n n", "[" + (n -= this.getHierarchy() * 5) + "!][100!][100!][100!][100!][100!][300:400:400]", ""));
            this.add((Component)this.jlabel, "growx, ay top, gaptop 5, gapleft " + this.getHierarchy() * 5);
            this.add((Component)this.help, "cell 6 0, wrap");
        }
    }

    private void initialize(Element element, ControlledPanel controlledPanel) {
        this.dependencies = 0;
        this.element = element;
        this.label = this.key = element.getAttribute("key");
        this.section = element.getAttribute("section");
        this.hashKey = this.section.toUpperCase() + "::" + this.key.toUpperCase();
        this.optional = element.getAttribute("optional").equals("true");
        this.jlabel = new JLabel(this.label + ":      ");
        this.jlabel.setForeground(GUI.LABEL_COLOR);
        this.setBackground(Color.white);
        this.setVisible(true);
        this.helptext = XMLHelper.getChildElementContent(element, "help");
        this.help = ControlledPanel.createHelpPane("<html>" + this.helptext + "</html>");
        if (this.helptext != null) {
            this.help.setText(this.helptext);
        }
        if (controlledPanel != null) {
            this.setHierarchy(controlledPanel.getHierarchy() + 1);
        } else {
            this.setHierarchy(0);
        }
    }

    public static ControlledPanel createSingleParameterPanel(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        ControlledPanel controlledPanel2;
        if (element.hasAttribute("counter")) {
            controlledPanel2 = new DuplicatorPanel(element, controlledPanel);
        } else if (element.getTagName().equals("frame")) {
            controlledPanel2 = new FramePanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("path") || element.getAttribute("type").equals("file")) {
            controlledPanel2 = new PathPanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("alternative") || element.getAttribute("type").equals("logical")) {
            controlledPanel2 = new AlternativePanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("choice")) {
            controlledPanel2 = new CheckBoxPanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("integer") || element.getAttribute("type").equals("integer+")) {
            controlledPanel2 = new IntegerPanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("decimal")) {
            controlledPanel2 = new DecimalPanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("double")) {
            controlledPanel2 = new TextfieldPanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("string") || element.getAttribute("type").equals("char") || element.getAttribute("type").equals("cell")) {
            controlledPanel2 = new TextfieldPanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("combination")) {
            controlledPanel2 = new CombinedPanel(element, controlledPanel);
        } else if (element.getAttribute("type").equals("selector")) {
            controlledPanel2 = new SelectorPanel(element, controlledPanel);
        } else {
            throw new GUIBuildException("Cannot create a GUI panel for a parameter of type " + element.getAttribute("type"));
        }
        return controlledPanel2;
    }

    public static JEditorPane createHelpPane(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setFont(new Font("SansSerif", 0, 12));
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setForeground(Color.GRAY);
        jEditorPane.addHyperlinkListener(GUIBuilder.gui);
        if (string != null) {
            jEditorPane.setText("<html>" + string + "</html>");
        } else {
            jEditorPane.setText("<html></html>");
        }
        return jEditorPane;
    }

    public void setHierarchy(int n) {
        this.hierarchy = n;
    }

    public int getHierarchy() {
        return this.hierarchy;
    }

    public abstract void close();

    public Component getComponent() {
        return this;
    }

    public int getDependencies() {
        return this.dependencies;
    }

    public String getKey() {
        return this.key;
    }

    public abstract String getValue();

    public synchronized void hold() {
        ++this.dependencies;
    }

    public synchronized boolean isNeeded() throws GUIBuildException {
        if (this.dependencies == 0) {
            return false;
        }
        if (this.dependencies > 0) {
            return true;
        }
        throw new GUIBuildException("Inplausible number of dependencies on panel");
    }

    public boolean isOptional() {
        return this.optional;
    }

    public synchronized void release() {
        --this.dependencies;
    }

    public void set(HashMap hashMap, String string, String string2) {
        System.out.println("Set not implemented for ControlledPanel: 1");
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public void setKey(String string) {
        this.key = string;
        this.element.setAttribute("key", string);
        this.jlabel.setText(this.label + ":      ");
    }

    public String getSection() {
        return this.section;
    }
}

