%BALANCETHICKNESS class definition
%
%   Usage:
%      balancethickness=balancethickness();

classdef balancethickness
	properties (SetAccess=public) 
		spcthickness      = NaN;
		thickening_rate   = NaN;
		stabilization     = 0;
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- balancethickness -->');
            
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="spcthickness" type="',   	class(obj.spcthickness),'" default="',        convert2str(obj.spcthickness),'">',	'     <section name="balancethickness" />','     <help> thickness constraints (NaN means no constraint) [m] </help>','</parameter>');
            fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="thickening_rate" type="', 	class(obj.thickening_rate),'" default="',            convert2str(obj.thickening_rate),'">',     '     <section name="balancethickness" />','     <help> ice thickening rate used in the mass conservation (dh/dt) [m/yr] </help>','</parameter>');
            
            % balancethickness drop-down (1,2, or 3)
            fprintf(fid,'%s\n%s\n%s\n',        '<parameter key ="stabilization" type="alternative" optional="false">','     <section name="balancethickness" />','     <help> 0: None, 1: SU, 2: SSAs artificial diffusivity, 3:DG </help>');
            fprintf(fid,'%s\n','       <option value="1" type="string" default="true"> </option>');
            fprintf(fid,'%s\n','       <option value="2" type="string" default="false"> </option>');
            fprintf(fid,'%s\n%s\n','       <option value="3" type="string" default="false"> </option>','</parameter>');

        end % }}}
		function obj = balancethickness(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%Type of stabilization used
			obj.stabilization=1;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%Early return
			if solution~=BalancethicknessSolutionEnum(), return; end

			md = checkfield(md,'fieldname','balancethickness.spcthickness');
			md = checkfield(md,'fieldname','balancethickness.thickening_rate','size',[md.mesh.numberofvertices 1],'NaN',1);
			md = checkfield(md,'fieldname','balancethickness.stabilization','size',[1 1],'values',[0 1 2 3]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   balance thickness solution parameters:'));

			fielddisplay(obj,'spcthickness','thickness constraints (NaN means no constraint) [m]');
			fielddisplay(obj,'thickening_rate','ice thickening rate used in the mass conservation (dh/dt) [m/yr]');
			fielddisplay(obj,'stabilization','0: None, 1: SU, 2: SSA''s artificial diffusivity, 3:DG');

		end % }}}
		function marshall(obj,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'object',obj,'fieldname','spcthickness','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','thickening_rate','format','DoubleMat','mattype',1,'scale',1./yts);
			WriteData(fid,'object',obj,'fieldname','stabilization','format','Integer');
		end % }}}
	end
end
