md=triangle(model(),'../Exp/Square.exp',50000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);
md.stressbalance.requested_outputs={'default','DeviatoricStressxx','DeviatoricStressyy','DeviatoricStressxy'};
md.autodiff.isautodiff=true;
md.toolkits.DefaultAnalysis=issmmumpssolver();

md=solve(md,StressbalanceSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure',...
	'DeviatoricStressxx','DeviatoricStressyy','DeviatoricStressxy'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13};
field_values={...
	(md.results.StressbalanceSolution.Vx),...
	(md.results.StressbalanceSolution.Vy),...
	(md.results.StressbalanceSolution.Vel),...
	(md.results.StressbalanceSolution.Pressure),...
	(md.results.StressbalanceSolution.DeviatoricStressxx),...
	(md.results.StressbalanceSolution.DeviatoricStressyy),...
	(md.results.StressbalanceSolution.DeviatoricStressxy),...
	};
