md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=setflowequation(md,'SSA','all');
md.initialization.vx(:)=0.;
md.initialization.vy(:)=0.;
md.geometry.base=-700.-abs(md.mesh.y-500000.)/1000.;
md.geometry.bed =-700.-abs(md.mesh.y-500000.)/1000.;
md.geometry.thickness(:)=1000.;
md.geometry.surface=md.geometry.base+md.geometry.thickness;
md.surfaceforcings.mass_balance(:)=100.;
md.transient.isstressbalance=0;
md.transient.isgroundingline=1;
md.groundingline.migration='AggressiveMigration';
md.transient.requested_outputs={'IceVolume','IceVolumeAboveFloatation'};

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Bed1','Surface1','Thickness1','Floatingice1','IceVolume1','IceVolumeAboveFloatation1',...
	'Bed2','Surface2','Thickness2','Floatingice2','IceVolume2','IceVolumeAboveFloatation2',...
	'Bed3','Surface3','Thickness3','Floatingice3','IceVolume3','IceVolumeAboveFloatation3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).MaskGroundediceLevelset),...
	(md.results.TransientSolution(1).IceVolume),...
	(md.results.TransientSolution(1).IceVolumeAboveFloatation),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).MaskGroundediceLevelset),...
	(md.results.TransientSolution(2).IceVolume),...
	(md.results.TransientSolution(2).IceVolumeAboveFloatation),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).MaskGroundediceLevelset),...
	(md.results.TransientSolution(3).IceVolume),...
	(md.results.TransientSolution(3).IceVolumeAboveFloatation),...
	};
