%DEBUG class definition
%
%   Usage:
%      debug=debug();

classdef debug
	properties (SetAccess=public) 
		valgrind = false;
		gprof    = false;
		profiling = false;
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- Debug -->');
            
            %valgrind drop-down (0 or 1)
			fprintf(fid,'%s\n%s\n%s%s%s\n%s\n%s\n',    '<parameter key ="valgrind" type="alternative" optional="false">','     <section name="debug" />','     <help> use Valgrind to debug (0 or 1) </help>');
            fprintf(fid,'%s\n','       <option value="0" type="string" default="true"> </option>');
            fprintf(fid,'%s\n%s\n','       <option value="1" type="string" default="false"> </option>','</parameter>');
          
            fprintf(fid,'%s%s%s\n%s\n%s%s%s\n%s\n%s\n',    '<parameter key ="gprof" type="',              class(obj.gprof),'" optional="false">',              '     <section name="debug" />','        <option value="',convert2str(obj.gprof),'" type="string" default="true"></option>','     <help> use gnu-profiler to find out where the time is spent </help>','</parameter>');
            fprintf(fid,'%s%s%s\n%s\n%s%s%s\n%s\n',    '<parameter key ="profiling" type="',              class(obj.profiling),'" optional="false">',              '     <section name="debug" />','        <option value="',convert2str(obj.profiling),'" type="string" default="true"></option>','     <help> enables profiling (memory, flops, time) </help>','</parameter>');
        end % }}}
		function obj = debug(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
				end
			end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   debug parameters:'));

			fielddisplay(obj,'valgrind','use Valgrind to debug (0 or 1)');
			fielddisplay(obj,'gprof','use gnu-profiler to find out where the time is spent');
			fielddisplay(obj,'profiling','enables profiling (memory, flops, time)');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','profiling','format','Boolean');
		end % }}}
	end
end
