/*!\file: controlm1qn3_core.cpp
 * \brief: core of the control solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

#if defined (_HAVE_M1QN3_)
/*m1qn3 prototypes*/
extern "C" void *ctonbe_; // DIS mode : Conversion
extern "C" void *ctcabe_; // DIS mode : Conversion
extern "C" void *euclid_; // Scalar product
typedef void (*SimulFunc) (long*, long *, double [], double *, double [], long [], float [], double []);
extern "C" void m1qn3_ (void f(long*, long *, double [], double *, double [], long [], float [], double []),
			void **, void **, void **,
			long *, double [], double *, double [], double*, double *,
			double *, char [], long *, long *, long *, long *, long *, long *, long [], double [], long *,
			long *, long *, long [], float [], double []
			);

void simul(long* indic,long* n,double x[2],double* f,double g[2],long izs[1],float rzs[1],double dzs[1]){
	/*minimization of x^2+cy^4 where c>0 is a parameter*/
	double c=dzs[0];
	*f=x[0]*x[0]+c*x[1]*x[1]*x[1]*x[1];
	g[0]=2.*x[0];
	g[1]=4.*c*x[1]*x[1]*x[1];
}

void controlm1qn3_core(FemModel* femmodel){
	if(VerboseControl())_printf0_("   Initialize M1QN3 parameters\n");

	const int pbdim = 2;

	/*Solution parameters*/
	double c = 10.;

	/*output*/
	long omode;

	/*Function evaluation and gradient*/
	double f;
	double g[2]; /**/

	/*m1qn3 parameters*/
	SimulFunc costfuncion  = &simul;    /*Cost function address*/
	void**    prosca       = &euclid_;  /*Dot product function (euclid is the default)*/
	char      normtype[3];              /*Norm type: dfn = scalar product defined by prosca*/
	strcpy(normtype, "dfn");
	long      impres       = 0;         /*verbosity level*/
	long      imode[3]     = {0};
	long      indic        = 4;         /*compute f and g*/
	long      reverse      = 0;
	long      ndz          = 20000; /*Dimension of the working area*/
	double    dz[20000];            /*Working array*/
	long      iz[5];
	double    dxmin        = 1.e-10; /*Resolution for the solution x*/
	double    epsrel       = 1.e-5;  /*Gradient stopping criterion in ]0 1[ -> |gk|/|g1| < epsrel*/
	long      niter        = 200;    /*Maximum number of iterations*/
	long      nsim         = 200;    /*Maximum number of function calls*/
	long      io           = 6;      /*Channel number for the output*/
	/*Arrayes used by m1qn3 subroutines*/
	double    dzs[1];
	long      izs[5];
	float     rzs[1];


	/*Prepare initial guess*/
	long      n = pbdim;
	double    x[pbdim];
	for(int i=0;i<n;i++) x[i]=5.;
	dzs[0] = c;

	if(VerboseControl())_printf0_("   Computing initial solution\n");
	simul(&indic,&n,x,&f,g,izs,rzs,&dzs[0]);
	double f1=f;

	m1qn3_(costfuncion,prosca,&ctonbe_,&ctcabe_,
				&n,x,&f,g,&dxmin,&f1,
				&epsrel,normtype,&impres,&io,imode,&omode,&niter,&nsim,iz,dz,&ndz,
				&reverse,&indic,izs,rzs,dzs);

	switch(int(omode)){
		case 0:  _printf0_("Stop requiered \n"); break;
		case 1:  _printf0_("Stop on epsg (gradient too small)\n"); break;
		case 2:  _printf0_("Bad initialization\n"); break;
		case 3:  _printf0_("Line search failure\n"); break;
		case 4:  _printf0_("Maximum number of iterations exceeded\n");break;
		case 5:  _printf0_("Maximum number of function calls exceeded\n"); break;
		case 6:  _printf0_("stoped on dxmin during line search\n"); break;
		case 7:  _printf0_("<g,d> > 0  or  <y,s> <0\n"); break;
		default: _printf0_("Unknown end condition\n");
	}

	_printf0_(" == Final cost function = "<< f <<"\n");
	_printf0_(" == Final x = ["<<x[0]<<" "<<x[1]<<"]\n");
}
#else
void controlm1qn3_core(FemModel* femmodel){
	_error_("M1QN3 not installed");
}
#endif //_HAVE_TAO_ 
