/*!\file: extrudefrombase_core.cpp
 * \brief: core of the extrusion solution
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../solutionsequences/solutionsequences.h"
#include "../modules/modules.h"

void extrudefrombase_core(FemModel* femmodel){

	/*Intermediaries*/
	int elementtype;

	if(VerboseSolution()) _printf0_("extruding solution from base...\n");

	 femmodel->parameters->FindParam(&elementtype,MeshElementtypeEnum);
	 if(elementtype==PentaEnum){
		 int inputenum; femmodel->parameters->FindParam(&inputenum,InputToExtrudeEnum);
		 InputExtrudex(femmodel,inputenum);
	 }
	 else{
		 /*Call on core computations: */
		 femmodel->SetCurrentConfiguration(ExtrudeFromBaseAnalysisEnum);
		 femmodel->UpdateConstraintsExtrudeFromBasex();
		 solutionsequence_linear(femmodel);
	 }

}
