
/*!\file:  TetraRef.h
 * \brief abstract class for handling Tetra oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 

#ifndef _TETRAREF_H_
#define _TETRAREF_H_

class GaussTetra;

class TetraRef{

	public: 
		int* element_type_list;
		int  element_type;

		TetraRef();
		TetraRef(const int nummodels);
		~TetraRef();

		/*Management*/
		void SetElementType(int type,int type_counter);
		void GetBprimeMasstransport(IssmDouble* Bprime, IssmDouble* xyz_list, GaussTetra* gauss);
		void GetJacobian(IssmDouble* J, IssmDouble* xyz_list,GaussTetra* gauss);
		void GetJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,GaussTetra* gauss);
		void GetJacobianDeterminantFace(IssmDouble*  Jdet, IssmDouble* xyz_list,GaussTetra* gauss);
		void GetJacobianInvert(IssmDouble* Jinv, IssmDouble* xyz_list,GaussTetra* gauss);
		void GetNodalFunctions(IssmDouble* basis,GaussTetra* gauss);
		void GetNodalFunctions(IssmDouble* basis,GaussTetra* gauss,int finiteelement);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list, GaussTetra* gauss);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list, GaussTetra* gauss,int finiteelement);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,GaussTetra* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,GaussTetra* gauss,int finiteelement);
		void GetInputDerivativeValue(IssmDouble* p, IssmDouble* plist,IssmDouble* xyz_list, GaussTetra* gauss);
		void GetInputValue(IssmDouble* p, IssmDouble* plist, GaussTetra* gauss);
		void GetInputValue(IssmDouble* p, IssmDouble* plist, GaussTetra* gauss,int finiteelement);

		int  NumberofNodes(void);
		int  NumberofNodes(int finiteelement);
		int  NumberofNodesVelocity(void);
		int  NumberofNodesPressure(void);
		int  VelocityInterpolation(void);
		int  PressureInterpolation(void);
		int  TensorInterpolation(void);
};
#endif
