/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 

#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{*/
#include "../../datastructures/datastructures.h"
#include "../../toolkits/toolkits.h"
#include "../Update.h"
class DataSet;
class Parameters;
class Parameter;
class Elements;
class Loads;
class Nodes;
class Node;
class Vertices;
class Vertex;
class Materials;
class Material;
class Matpar;
class Inputs;
class Input;
class Gauss;
class ElementVector;
template <class doublematrix> class Matrix;
template <class doubletype> class Vector;
class ElementMatrix;
class ElementVector;
/*}}}*/

class Element: public Object,public Update{

	public:
		int          id;
		int          sid;
		Inputs      *inputs;
		Node       **nodes;
		Vertex     **vertices;
		Material    *material;
		Matpar      *matpar;
		Parameters  *parameters;

	public: 
		/*Constructors/Destructores*/
		Element();
		~Element();

		/*Functions*/
		void       AddInput(Input* input_in);
		/* bool       AllActive(void); */
		/* bool       AnyActive(void); */
		void       CoordinateSystemTransform(IssmDouble** ptransform,Node** nodes,int numnodes,int* cs_array);
		void       Echo();
		void       DeepEcho();
		void       DeleteMaterials(void);
		IssmDouble Divergence(void);
		void       ThermalToEnthalpy(IssmDouble* penthalpy,IssmDouble temperature,IssmDouble waterfraction,IssmDouble pressure);
		void       EnthalpyToThermal(IssmDouble* ptemperature,IssmDouble* pwaterfraction,IssmDouble enthalpy,IssmDouble pressure);
		IssmDouble EnthalpyDiffusionParameter(IssmDouble enthalpy,IssmDouble pressure);
		IssmDouble EnthalpyDiffusionParameterVolume(int numvertices,IssmDouble* enthalpy,IssmDouble* pressure);
		void       FindParam(bool* pvalue,int paramenum);
		void       FindParam(int* pvalue,int paramenum);
		void       FindParam(IssmDouble* pvalue,int paramenum);
		void       FindParam(int** pvalues,int* psize,int paramenum);
		void	     GetDofList(int** pdoflist,int approximation_enum,int setenum);
		void	     GetDofListVelocity(int** pdoflist,int setenum);
		void	     GetDofListPressure(int** pdoflist,int setenum);
		Input*     GetInput(int inputenum);
		void       GetInputListOnNodes(IssmDouble* pvalue,int enumtype);
		void       GetInputListOnNodes(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue);
		void       GetInputListOnNodesVelocity(IssmDouble* pvalue,int enumtype);
		void       GetInputListOnVertices(IssmDouble* pvalue,int enumtype);
		void       GetInputListOnVertices(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue);
		void       GetInputValue(bool* pvalue,int enum_type);
		void       GetInputValue(int* pvalue,int enum_type);
		void       GetInputValue(IssmDouble* pvalue,int enum_type);
		void       GetInputValue(IssmDouble* pvalue,Gauss* gauss,int enum_type);
		IssmDouble GetMaterialParameter(int enum_in);
		void       GetNodesSidList(int* sidlist);
		void       GetNodesLidList(int* lidlist);
		void       GetPhi(IssmDouble* phi, IssmDouble*  epsilon, IssmDouble viscosity);
		void       GetVectorFromInputs(Vector<IssmDouble>* vector, int name_enum);
		void	     GetVertexPidList(int* pidlist);
		void       GetVerticesCoordinates(IssmDouble** xyz_list);
		void       GetVerticesSidList(int* sidlist);
		void       GetVerticesConnectivityList(int* connectivitylist);
		bool       HasNodeOnBase();
		bool       HasNodeOnSurface();
		int        Id();
		int        Sid();
		void       InputChangeName(int enum_type,int enum_type_old);
		void       InputCreate(IssmDouble* vector,IoModel* iomodel,int M,int N,int vector_type,int vector_enum,int code);
		void       InputDuplicate(int original_enum,int new_enum);
		void       InputUpdateFromConstant(IssmDouble constant, int name);
		void       InputUpdateFromConstant(int constant, int name);
		void       InputUpdateFromConstant(bool constant, int name);
		bool       IsIceInElement();
		bool	     IsInput(int name);
		bool       IsFloating(); 
		ElementVector*  NewElementVector(int approximation_enum=NoneApproximationEnum);
		ElementMatrix*  NewElementMatrix(int approximation_enum=NoneApproximationEnum);
		ElementMatrix*  NewElementMatrixCoupling(int number_nodes,int approximation_enum=NoneApproximationEnum);
		IssmDouble PureIceEnthalpy(IssmDouble pressure);
		void       ResultInterpolation(int* pinterpolation,int*nodesperelement,int output_enum);
		void       ResultToVector(Vector<IssmDouble>* vector,int output_enum);
		void       ResultToPatch(IssmDouble* values,int nodesperelement,int output_enum);
		void       SetwiseNodeConnectivity(int* d_nz,int* o_nz,Node* node,bool* flags,int* flagsindices,int set1_enum,int set2_enum);
		void       StrainRateSSA(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input);
		void       StrainRateSSA1d(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input);
		void       StrainRateHO(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input);
		void       StrainRateHO2dvertical(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input);
		void       StrainRateFS(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input);
		IssmDouble TMeltingPoint(IssmDouble pressure);
		void       TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,int cs_enum);
		void       TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int cs_enum);
		void       TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int* cs_array);
		void       TransformLoadVectorCoord(ElementVector* pe,int cs_enum);
		void       TransformLoadVectorCoord(ElementVector* pe,int* cs_array);
		void       TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int cs_enum);
		void       TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int* cs_array);
		void       TransformSolutionCoord(IssmDouble* solution,int cs_enum);
		void       TransformSolutionCoord(IssmDouble* solution,int* cs_array);
		void       TransformSolutionCoord(IssmDouble* solution,int numnodes,int cs_enum);
		void       TransformSolutionCoord(IssmDouble* solution,int numnodes,int* cs_array);
		void       TransformSolutionCoord(IssmDouble* solution,Node** nodes,int numnodes,int cs_enum);
		void       TransformSolutionCoord(IssmDouble* solution,Node** nodes,int numnodes,int* cs_array);
		void       TransformStiffnessMatrixCoord(ElementMatrix* Ke,int cs_enum);
		void       TransformStiffnessMatrixCoord(ElementMatrix* Ke,int* cs_array);
		void       TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int cs_enum);
		void       TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int* cs_array);
		void       ViscousHeatingCreateInput(void);
		void       ViscosityFS(IssmDouble* pviscosity,int dim,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input);
		void       ViscosityHO(IssmDouble* pviscosity,int dim,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input);
		void       ViscosityL1L2(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* surf);
		void       ViscositySSA(IssmDouble* pviscosity,int dim,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input);
		void       ViscositySSADerivativeEpsSquare(IssmDouble* pmu_prime,IssmDouble* epsilon);
		void       ViscosityHODerivativeEpsSquare(IssmDouble* pmu_prime,IssmDouble* epsilon);
		void       ViscosityFSDerivativeEpsSquare(IssmDouble* pmu_prime,IssmDouble* epsilon);
		void       TransformLoadVectorCoord(ElementVector* pe,int numnodes,int transformenum){_error_("not implemented yet");};/*Tiling only*/
		void       TransformLoadVectorCoord(ElementVector* pe,int numnodes,int* transformenum_list){_error_("not implemented yet");};/*Tiling only*/
		void       TransformStiffnessMatrixCoord(ElementMatrix* Ke,int numnodes,int* transformenum_list){_error_("not implemented yet");};/*Tiling only*/

		/*Virtual functions*/
		virtual void       AddBasalInput(int input_enum, IssmDouble* values, int interpolation_enum)=0;
		virtual void       AddInput(int input_enum, IssmDouble* values, int interpolation_enum)=0;
		virtual IssmDouble CharacteristicLength(void)=0;
		virtual void       Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters)=0;
		virtual void       SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   ElementSizes(IssmDouble* phx,IssmDouble* phy,IssmDouble* phz)=0;

		virtual int    FiniteElement(void)=0;
		virtual IssmDouble MinEdgeLength(IssmDouble* xyz_list)=0;
		virtual void   NodalFunctions(IssmDouble* basis,Gauss* gauss)=0;
		virtual void   NodalFunctionsP1(IssmDouble* basis,Gauss* gauss)=0;
		virtual void   NodalFunctionsVelocity(IssmDouble* basis, Gauss* gauss)=0;
		virtual void   NodalFunctionsPressure(IssmDouble* basis, Gauss* gauss)=0;
		virtual void   NodalFunctionsTensor(IssmDouble* basis, Gauss* gauss)=0;
		virtual void   NodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   NodalFunctionsP1Derivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   NodalFunctionsMINIDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   NodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   NormalSection(IssmDouble* normal,IssmDouble* xyz_list)=0;
		virtual void   NormalTop(IssmDouble* normal,IssmDouble* xyz_list)=0;
		virtual void   NormalBase(IssmDouble* normal,IssmDouble* xyz_list)=0;

		virtual Element* GetUpperElement(void)=0;
		virtual Element* GetLowerElement(void)=0;
		virtual Element* GetSurfaceElement(void)=0;
		virtual Element* GetBasalElement(void)=0;

		virtual void   JacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   JacobianDeterminantLine(IssmDouble* Jdet, IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   JacobianDeterminantSurface(IssmDouble* Jdet, IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   JacobianDeterminantBase(IssmDouble* Jdet,IssmDouble* xyz_list_base,Gauss* gauss)=0;
		virtual void   JacobianDeterminantTop(IssmDouble* Jdet,IssmDouble* xyz_list_base,Gauss* gauss)=0;
		virtual void   GetSolutionFromInputsOneDof(Vector<IssmDouble>* solution,int solutionenum)=0;
		virtual int    GetNodeIndex(Node* node)=0;
		virtual int    GetNumberOfNodes(void)=0;
		virtual int    GetNumberOfVertices(void)=0;

		virtual bool   IsNodeOnShelfFromFlags(IssmDouble* flags)=0; 
		virtual bool   IsOnBase()=0;
		virtual bool   IsOnSurface()=0;
		virtual void   GetGroundedPart(int* point1,IssmDouble* fraction1,IssmDouble* fraction2, bool* mainlyfloating)=0;
		virtual IssmDouble GetGroundedPortion(IssmDouble* xyz_list)=0;
		virtual void   GetInputValue(IssmDouble* pvalue,Node* node,int enumtype)=0;
		virtual Node*  GetNode(int node_number)=0;
		virtual void   GetVerticesCoordinatesBase(IssmDouble** xyz_list)=0;
		virtual void   GetVerticesCoordinatesTop(IssmDouble** xyz_list)=0;
		virtual IssmDouble GetXcoord(Gauss* gauss)=0;
		virtual IssmDouble GetYcoord(Gauss* gauss)=0;
		virtual IssmDouble GetZcoord(Gauss* gauss)=0;
		virtual int    GetElementType(void)=0;

		virtual IssmDouble SurfaceArea(void)=0;
		virtual void   InputDepthAverageAtBase(int enum_type,int average_enum_type)=0;
		virtual void   ComputeSigmaNN(void)=0;
		virtual void   ComputeBasalStress(Vector<IssmDouble>* sigma_b)=0;
		virtual void   ComputeStrainRate()=0;
		virtual void   ComputeStrainRate(Vector<IssmDouble>* eps)=0;
		virtual void   ComputeStressTensor(void)=0;
		virtual void   ComputeDeviatoricStressTensor(void)=0;

		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type,int finite_element)=0;
		virtual void   InputExtrude(int input_enum)=0;
		virtual void   InputUpdateFromSolutionOneDofCollapsed(IssmDouble* solution,int inputenum)=0;
		virtual void   InputUpdateFromSolutionOneDof(IssmDouble* solution,int inputenum)=0;

		virtual int    NodalValue(IssmDouble* pvalue, int index, int natureofdataenum)=0;
		virtual int    NumberofNodesVelocity(void)=0;
		virtual int    NumberofNodesPressure(void)=0;
		virtual Gauss* NewGauss(void)=0;
		virtual Gauss* NewGauss(int order)=0;
      virtual Gauss* NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order)=0;
      virtual Gauss* NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order_horiz,int order_vert)=0;
      virtual Gauss* NewGauss(int point1,IssmDouble fraction1,IssmDouble fraction2,bool mainlyfloating,int order)=0;
		virtual Gauss* NewGaussBase(int order)=0;
		virtual Gauss* NewGaussLine(int vertex1,int vertex2,int order)=0;
		virtual Gauss* NewGaussTop(int order)=0;

		virtual void   InputScale(int enum_type,IssmDouble scale_factor)=0;
		virtual IssmDouble TimeAdapt()=0;
		virtual void   PositiveDegreeDay(IssmDouble* pdds,IssmDouble* pds,IssmDouble signorm)=0;
		virtual void   Delta18oParameterization(void)=0;
		virtual void   SmbGradients(void)=0;
	   virtual Element*   SpawnBasalElement(void)=0;
		virtual Element*   SpawnTopElement(void)=0;
		virtual void   ReduceMatrices(ElementMatrix* Ke,ElementVector* pe)=0;
		virtual void   ResetFSBasalBoundaryCondition()=0;
		virtual void   SetTemporaryElementType(int element_type_in)=0;
		virtual IssmDouble StabilizationParameter(IssmDouble u, IssmDouble v, IssmDouble w, IssmDouble diameter, IssmDouble kappa)=0;
		virtual void   ValueP1OnGauss(IssmDouble* pvalue,IssmDouble* values,Gauss* gauss)=0;
		virtual void   ValueP1DerivativesOnGauss(IssmDouble* dvalue,IssmDouble* values,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   ViscousHeating(IssmDouble* pphi,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input)=0;

		virtual int    VelocityInterpolation()=0;
		virtual int    PressureInterpolation()=0;
		virtual int    TensorInterpolation()=0;
		virtual bool   IsZeroLevelset(int levelset_enum)=0;
		virtual bool   IsIcefront(void)=0;
		virtual bool   IsFaceOnBoundary(void)=0;
		virtual void   ZeroLevelsetCoordinates(IssmDouble** pxyz_zero,IssmDouble* xyz_list,int levelsetenum)=0;
		virtual void   GetIcefrontCoordinates(IssmDouble** pxyz_front,IssmDouble* xyz_list,int levelsetenum)=0;
		virtual void   GetNormalFromLSF(IssmDouble *pnormal)=0;

		virtual void   AverageOntoPartition(Vector<IssmDouble>* partition_contributions,Vector<IssmDouble>* partition_areas,IssmDouble* vertex_response,IssmDouble* qmu_part)=0;
		virtual void   MinVel(IssmDouble* pminvel)=0;
		virtual void   MaxVel(IssmDouble* pmaxvel)=0;
		virtual void   MinVx(IssmDouble* pminvx)=0;
		virtual void   MaxVx(IssmDouble* pmaxvx)=0;
		virtual void   MaxAbsVx(IssmDouble* pmaxabsvx)=0;
		virtual void   MinVy(IssmDouble* pminvy)=0;
		virtual void   MaxVy(IssmDouble* pmaxvy)=0;
		virtual void   MaxAbsVy(IssmDouble* pmaxabsvy)=0;
		virtual void   MinVz(IssmDouble* pminvz)=0;
		virtual void   MaxVz(IssmDouble* pmaxvz)=0;
		virtual void   MaxAbsVz(IssmDouble* pmaxabsvz)=0;
		virtual IssmDouble MassFlux(IssmDouble* segment)=0;
		virtual IssmDouble MassFlux(IssmDouble x1,IssmDouble y1, IssmDouble x2, IssmDouble y2,int segment_id)=0;
		virtual void   ElementResponse(IssmDouble* presponse,int response_enum)=0;
		virtual IssmDouble IceVolume(void)=0;
		virtual IssmDouble IceVolumeAboveFloatation(void)=0;
		virtual IssmDouble TotalSmb(void)=0;
		virtual IssmDouble Misfit(int modelenum,int observationenum,int weightsenum)=0;
		virtual IssmDouble MisfitArea(int weightsenum)=0;
		virtual int    VertexConnectivity(int vertexindex)=0;
		virtual void   VerticalSegmentIndices(int** pindices,int* pnumseg)=0;

		#ifdef _HAVE_GIA_
		virtual void   GiaDeflection(Vector<IssmDouble>* wg,Vector<IssmDouble>* dwgdt,IssmDouble* x,IssmDouble* y)=0;
		#endif

		virtual void   Gradj(Vector<IssmDouble>* gradient,int control_type,int control_index)=0;
		virtual IssmDouble ThicknessAbsMisfit(void)=0;
		virtual IssmDouble SurfaceAbsVelMisfit(void)=0;
		virtual IssmDouble SurfaceRelVelMisfit(void)=0;
		virtual IssmDouble SurfaceLogVelMisfit(void)=0;
		virtual IssmDouble SurfaceLogVxVyMisfit(void)=0;
		virtual IssmDouble SurfaceAverageVelMisfit(void)=0;
		virtual IssmDouble ThicknessAbsGradient(void)=0;
		virtual IssmDouble ThicknessAlongGradient(void)=0;
		virtual IssmDouble ThicknessAcrossGradient(void)=0;
		virtual IssmDouble BalancethicknessMisfit(void)=0;
		virtual IssmDouble RheologyBbarAbsGradient(void)=0;
		virtual IssmDouble DragCoefficientAbsGradient(void)=0;
		virtual void   ControlInputGetGradient(Vector<IssmDouble>* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputSetGradient(IssmDouble* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputScaleGradient(int enum_type, IssmDouble scale)=0;
		virtual void   ControlToVectors(Vector<IssmPDouble>* vector_control, Vector<IssmPDouble>* vector_gradient,int control_enum)=0;
		virtual void   GetVectorFromControlInputs(Vector<IssmDouble>* gradient,int control_enum,int control_index,const char* data)=0;
		virtual void   SetControlInputsFromVector(IssmDouble* vector,int control_enum,int control_index)=0;
		virtual void   InputControlUpdate(IssmDouble scalar,bool save_parameter)=0;

		virtual void UpdateConstraintsExtrudeFromBase(void)=0;
		virtual void UpdateConstraintsExtrudeFromTop(void)=0;

		virtual void   MigrateGroundingLine(IssmDouble* sheet_ungrounding)=0;
		virtual void   FSContactMigration(Vector<IssmDouble>* vertexgrounded,Vector<IssmDouble>* vertexfloating)=0;
		virtual void   PotentialUngrounding(Vector<IssmDouble>* potential_sheet_ungrounding)=0;
		virtual int    UpdatePotentialUngrounding(IssmDouble* potential_sheet_ungrounding,Vector<IssmDouble>* vec_nodes_on_iceshelf,IssmDouble* nodes_on_iceshelf)=0;

};
#endif
