/*!\file: CreateFemModel.cpp
 * \brief: create all the datasets, vectors and matrices needed to run the finite element analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateFemModel"

#include "../objects/objects.h"
#include "../io/io.h"
#include "../issm.h"

void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,int analysis_type,int sub_analysis_type){

	/*Model output: */
	DataSet*            elements=NULL;
	DataSet*            nodes=NULL;
	DataSet*            constraints=NULL;
	DataSet*            loads=NULL;
	DataSet*            materials=NULL;
	DataSet*            parameters=NULL;
	Vec                 partition=NULL;
	Vec                 tpartition=NULL;
	Vec                 yg=NULL;
	Mat                 Rmg=NULL;
	Mat                 Gmn=NULL;
	NodeSets*           nodesets=NULL;
	Vec                 ys=NULL;
	Vec                 ys0=NULL;

	/*intermediary: */
	Model* model=NULL;
	

	_printf_("   fill model with matlab workspace data\n");
	ModelInit(&model,MODEL); 

	_printf_("   specifying analysis\n");
	if (analysis_type!=0){
		model->analysis_type=analysis_type;
	}
	if (sub_analysis_type!=0){
		model->sub_analysis_type=sub_analysis_type;
	}

	_printf_("   create datasets:\n");
	CreateDataSets(&elements,&nodes,&materials,&constraints,&loads,&parameters,model,MODEL);

	_printf_("   create degrees of freedom: \n");
	Dofx( &partition,&tpartition,elements,nodes, parameters);
	
	_printf_("   create single point constraints: \n");
	SpcNodesx( &yg, nodes,constraints); 
	
	_printf_("   create rigid body constraints:\n");
	MpcNodesx( &Rmg, nodes,constraints); 
	
	_printf_("   create node sets:\n");
	BuildNodeSetsx(&nodesets, nodes);

	_printf_("   reducing single point constraints vector:\n");
	Reducevectorgtosx(&ys,&ys0, yg,nodesets);
	
	_printf_("   normalizing rigid body constraints matrix:\n");
	NormalizeConstraintsx(&Gmn, Rmg,nodesets);

	_printf_("   configuring element and loads:\n");
	ConfigureObjectsx(elements, loads, nodes, materials);

	_printf_("   process parameters:\n");
	ProcessParamsx( parameters, partition);

	_printf_("   free ressources:\n");
	DeleteModel(&model);

	/*Assign output pointers:*/
	femmodel->elements=elements;
	femmodel->nodes=nodes;
	femmodel->constraints=constraints;
	femmodel->loads=loads;
	femmodel->materials=materials;
	femmodel->parameters=parameters;
	femmodel->partition=partition;
	femmodel->tpartition=tpartition;
	femmodel->yg=yg;
	femmodel->Rmg=Rmg;
	femmodel->Gmn=Gmn;
	femmodel->nodesets=nodesets;
	femmodel->ys=ys;
	femmodel->ys0=ys0;
}
