import numpy as npy
from plotoptions import plotoptions

try:
	import pylab as p
	import matplotlib.pyplot as plt
	from mpl_toolkits.axes_grid1 import ImageGrid
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

from plot_manager import plot_manager
from math import ceil, sqrt

def plotmodel(md,*args):
	'''
	at command prompt, type 'plotdoc' for additional documentation
	'''

	#First process options 
	options=plotoptions(*args)

	#get number of subplots
	subplotwidth=ceil(sqrt(options.numberofplots))
	
	#Get figure number and number of plots
	figurenumber=options.figurenumber
	numberofplots=options.numberofplots

	#get hold
	hold=options.list[0].getfieldvalue('hold',False)

	#if nrows and ncols specified, then bypass
	if options.list[0].exist('nrows'):
		nrows=options.list[0].getfieldvalue('nrows')
		nr=True
	else:
		nrows=npy.ceil(numberofplots/subplotwidth)
		nr=False
	
	if options.list[0].exist('ncols'):
		ncols=options.list[0].getfieldvalue('ncols')
		nc=True
	else:
		ncols=int(subplotwidth)
		nc=False
	ncols=int(ncols)
	nrows=int(nrows)
	
	#check that nrows and ncols were given at the same time!
	if not nr==nc:
		raise StandardError('error: nrows and ncols need to be specified together, or not at all')
	
	#Go through plots
	if numberofplots:
		
		if not hold: # TODO need to also check whether figurenumber is a new plot so that old plots are not mistakenly cleared
			plt.cla()

		#if figsize specified
		if options.list[0].exist('figsize'):
			figsize=options.list[0].getfieldvalue('figsize')
			fig=plt.figure(figurenumber,figsize=figsize,tight_layout=True)
		else:
			fig=plt.figure(figurenumber,tight_layout=True)
		fig.clf()
	
		# options to pass/construct: axes_pad, share_all, label_mode ("1","L","all"), cbar_mode (none,single,each), cbar_location(right,top)
		axgrid=ImageGrid(fig, 111,
				nrows_ncols=(nrows,ncols),
				direction='row',
				axes_pad=0.05,
				add_all=True,
				share_all=True,
				label_mode='all',
				cbar_mode='each',
				cbar_location='right',
				cbar_size='5%',
				cbar_pad=0.05
				)

		for i in xrange(numberofplots):
			plot_manager(options.list[i].getfieldvalue('model',md),options.list[i],fig,axgrid[i])

		plt.show()
	else:
		raise StandardError('plotmodel error message: no output data found.')
