/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.GUIBuilder;
import main.PanelNode;
import net.miginfocom.swing.MigLayout;

public class GUI
extends JFrame
implements WindowListener,
ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = -2428732881181670225L;
    public static PanelNode rootNode = null;
    private static String title = GUI.class.getPackage().getImplementationTitle() + " " + GUI.class.getPackage().getImplementationVersion();
    public static final Color LABEL_COLOR = Color.decode("#000080");
    public static Color NORMAL_BACKGROUND_COLOR = Color.decode("#EEEEEE");
    public static Color WARNING_BACKGROUND_COLOR = Color.decode("#FF0011");
    public static ImageIcon openicon = new ImageIcon(GUI.class.getClassLoader().getResource("resources/icons/xml_open.png"));
    public static ImageIcon openiniicon = new ImageIcon(GUI.class.getClassLoader().getResource("resources/icons/fileopen.png"));
    public static ImageIcon exporticon = new ImageIcon(GUI.class.getClassLoader().getResource("resources/icons/filesave.png"));
    public static ImageIcon previewicon = new ImageIcon(GUI.class.getClassLoader().getResource("resources/icons/kghostview.png"));
    public static ImageIcon reseticon = new ImageIcon(GUI.class.getClassLoader().getResource("resources/icons/reset.png"));
    private final JButton createbutton;
    private final JButton previewButton;
    private final JButton openbutton;
    private final JButton openinibutton;
    private final JButton resetbutton;
    private final JTabbedPane tabpane;
    private final JToolBar toolbar;
    private HashMap<String, JPanel> tabpanels;
    private String configFilePath = System.getProperty("user.dir");
    private String iniFilePath = System.getProperty("user.dir");

    public GUI() throws GUIBuildException {
        super(title);
        this.tabpanels = new HashMap();
        Dimension dimension = new Dimension(1280, 800);
        Dimension dimension2 = null;
        if (this.getMaximizedBounds() == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            dimension2 = toolkit.getScreenSize();
            this.setMaximizedBounds(new Rectangle(0, 0, (int)dimension2.getWidth(), (int)dimension2.getHeight()));
        } else {
            dimension2 = this.getMaximizedBounds().getSize();
        }
        if (dimension2.height < dimension.height) {
            dimension.height = dimension2.height;
            if (dimension.height > 100) {
                dimension.height -= 25;
            }
        }
        if (dimension2.width < dimension.width) {
            dimension.width = dimension2.width;
            if (dimension.width > 100) {
                dimension.width -= 25;
            }
        }
        this.setSize(dimension);
        this.setVisible(true);
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
        this.toolbar.setFloatable(false);
        this.setVisible(true);
        this.add((Component)this.toolbar, "West");
        this.tabpane = new JTabbedPane();
        this.add(this.tabpane);
        this.tabpane.setVisible(true);
        this.openbutton = new JButton(openicon);
        this.openbutton.setActionCommand("open config");
        this.openbutton.setToolTipText("Open XML-configuration");
        this.openbutton.addActionListener(this);
        this.toolbar.add(this.openbutton);
        this.openinibutton = new JButton(openiniicon);
        this.openinibutton.setActionCommand("open ini");
        this.openinibutton.setToolTipText("Open existing INI file");
        this.openinibutton.addActionListener(this);
        this.toolbar.add(this.openinibutton);
        this.resetbutton = new JButton(reseticon);
        this.resetbutton.setActionCommand("reset");
        this.resetbutton.setToolTipText("Reset Interface");
        this.resetbutton.addActionListener(this);
        this.toolbar.add(this.resetbutton);
        this.createbutton = new JButton(exporticon);
        this.createbutton.setActionCommand("write config");
        this.createbutton.setToolTipText("Write to INI-file");
        this.createbutton.addActionListener(this);
        this.toolbar.add(this.createbutton);
        this.previewButton = new JButton(previewicon);
        this.previewButton.setActionCommand("preview");
        this.previewButton.setToolTipText("Preview INI-file");
        this.previewButton.addActionListener(this);
        this.toolbar.add(this.previewButton);
        this.addWindowListener(this);
        rootNode = new PanelNode("");
    }

    public void setApplicationForTitle(String string) {
        if (string.equals("")) {
            this.setTitle(title);
        } else {
            this.setTitle(title + " for " + string);
        }
    }

    public void hideOpenButton() {
        this.openbutton.setVisible(false);
    }

    public void closeAllTabs() {
        this.tabpane.removeAll();
    }

    public void addToTab(ControlledPanel controlledPanel, String string, ControlledPanel controlledPanel2) throws GUIBuildException {
        Object object;
        Object object2;
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
        String string2 = controlledPanel.getSection().toUpperCase();
        String string3 = string2 + "::" + controlledPanel.getKey();
        PanelNode panelNode = rootNode.getChild(string2);
        if (panelNode == null) {
            object2 = new PanelNode(string2);
            panelNode = rootNode.add((PanelNode)object2);
        }
        if (controlledPanel2 != null) {
            panelNode = panelNode.get(controlledPanel2.getSection().toUpperCase() + "::" + controlledPanel2.getKey());
        }
        if (panelNode != null && (object2 = panelNode.get(string3)) == null) {
            object = new PanelNode(string3);
            object2 = panelNode.add((PanelNode)object);
        }
        if (this.tabpane.indexOfTab(string) == -1) {
            object2 = new JPanel();
            ((JComponent)object2).setBackground(Color.white);
            ((JComponent)object2).setVisible(true);
            ((Container)object2).setLayout(new MigLayout("wrap 1"));
            object = new JScrollPane((Component)object2);
            this.tabpane.add(string, (Component)object);
            this.tabpanels.put(string, (JPanel)object2);
        } else {
            object2 = this.tabpanels.get(string);
        }
        if (controlledPanel2 != null && this.containsPanel((Container)object2, controlledPanel2)) {
            controlledPanel2.add((Component)controlledPanel, "span");
        } else {
            ((Container)object2).add(controlledPanel);
        }
        this.validate();
    }

    public void removeFromTab(ControlledPanel controlledPanel, String string, ControlledPanel controlledPanel2) {
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
        int n = this.tabpane.indexOfTab(string2);
        Container container = (Container)this.tabpane.getComponentAt(n);
        PanelNode panelNode = rootNode.get(controlledPanel.getSection().toUpperCase() + "::" + controlledPanel.getKey());
        panelNode.getParent().remove(panelNode);
        if (controlledPanel2 != null && this.containsPanel(container, controlledPanel2)) {
            controlledPanel2.remove(controlledPanel);
        } else {
            container.remove(controlledPanel);
        }
        GUIBuilder.panelControl.remove(string, controlledPanel.getKey());
        container.repaint();
        this.validate();
    }

    public boolean containsPanel(Container container, JPanel jPanel) {
        for (Component component : container.getComponents()) {
            if (component == jPanel) {
                return true;
            }
            if (!this.containsPanel((Container)component, jPanel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("write config") && GUIBuilder.application != null) {
            GUIBuilder.panelControl.setRootNode(rootNode);
            try {
                GUIBuilder.printIOFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (GUIBuildException gUIBuildException) {
                gUIBuildException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals("preview") && GUIBuilder.application != null) {
            GUIBuilder.panelControl.setRootNode(rootNode);
            this.previewINIFile();
        } else if (actionEvent.getActionCommand().equals("reset") && GUIBuilder.application != null) {
            this.resetGUI();
        } else if (actionEvent.getActionCommand().equals("open config")) {
            this.openFile();
        } else if (actionEvent.getActionCommand().equals("open ini")) {
            this.openINIFile();
        }
    }

    public void resetGUI() {
        try {
            int n = GUIBuilder.closeFile();
            if (n == 2) {
                return;
            }
            GUIBuilder.buildGUI(GUIBuilder.currentConfigFile);
        }
        catch (GUIBuildException gUIBuildException) {
            gUIBuildException.printStackTrace();
        }
    }

    public void previewINIFile() {
        JFrame jFrame = new JFrame();
        jFrame.setSize(600, 800);
        jFrame.setVisible(true);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setText(GUIBuilder.panelControl.toString());
        jEditorPane.setVisible(true);
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setVisible(true);
        jFrame.add(jScrollPane);
        jFrame.validate();
        jFrame.repaint();
    }

    public void openINIFile() {
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(".ini files", "ini");
        JFileChooser jFileChooser = new JFileChooser(this.iniFilePath);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(new JPanel());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().toString();
            if (jFileChooser.getSelectedFile().isDirectory()) {
                return;
            }
            this.iniFilePath = jFileChooser.getSelectedFile().getParent();
            System.out.println("Opening INI file: " + string);
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                String string3 = "GENERAL::";
                String string4 = "";
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n2 = string2.indexOf(";");
                    int n3 = string2.indexOf("#");
                    if (n3 != -1 && n2 != -1) {
                        if (n3 < n2) {
                            n2 = n3;
                        }
                    } else if (n3 != -1 && n2 == -1) {
                        n2 = n3;
                    }
                    String string5 = null;
                    if (n2 != -1) {
                        string5 = string2.substring(n2);
                    }
                    if (-1 != n2) {
                        string2 = string2.substring(0, n2);
                    }
                    if (-1 != (n2 = string2.indexOf("#"))) {
                        string2 = string2.substring(0, n2);
                    }
                    if ((string2 = string2.trim()).length() > 1) {
                        if (string2.charAt(0) == '[') {
                            n2 = string2.indexOf("]");
                            if (n2 == -1 || n2 <= 1) continue;
                            if (!string4.equals("")) {
                                int n4 = string4.indexOf("\n");
                                string4 = string4.substring(0, n4);
                                hashMap2.put(string3, string4);
                                string4 = "";
                            }
                            string3 = string2.substring(1, n2).toUpperCase() + "::";
                            continue;
                        }
                        String[] stringArray = string2.split("=");
                        if (stringArray.length != 2) continue;
                        String string6 = stringArray[0].trim();
                        String string7 = stringArray[1].trim();
                        if (string6.length() <= 0) continue;
                        hashMap.put(string3 + string6.toUpperCase(), string7);
                        if (string5 != null) {
                            hashMap3.put(string3 + string6.toUpperCase(), string5);
                        }
                        if (string4.equals("")) continue;
                        hashMap2.put(string3 + string6.toUpperCase(), string4);
                        string4 = "";
                        continue;
                    }
                    if (string5 != null) {
                        string4 = string4 + string5;
                    }
                    string4 = string4 + "\n";
                }
                bufferedReader.close();
                GUIBuilder.setValues(hashMap, hashMap3, hashMap2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void openFile() {
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(".xml files", "xml");
        JFileChooser jFileChooser = new JFileChooser(this.configFilePath);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(new JPanel());
        if (n == 0) {
            int n2;
            if (GUIBuilder.application != null && (n2 = GUIBuilder.closeFile()) == 2) {
                return;
            }
            String string = jFileChooser.getSelectedFile().toString();
            if (jFileChooser.getSelectedFile().isDirectory()) {
                return;
            }
            this.configFilePath = jFileChooser.getSelectedFile().getParent();
            try {
                GUIBuilder.buildGUI(string);
            }
            catch (GUIBuildException gUIBuildException) {
                gUIBuildException.printStackTrace();
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
    }
}

