/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ColorCellRenderer;
import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import gui_elements.OptionPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import main.GUI;
import org.w3c.dom.Element;

public class AlternativePanel
extends OptionPanel {
    private static final long serialVersionUID = 4468480774697888798L;
    private final JComboBox box = new JComboBox<String>(this.labels);
    private String setKey = null;
    private String setValue = null;
    private boolean doSet = false;
    private HashMap setMap;

    public AlternativePanel(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        super(element, controlledPanel);
        this.box.insertItemAt("", 0);
        this.box.setVisible(true);
        this.box.setSelectedIndex(0);
        this.box.addItemListener(this);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.box.setRenderer(new ColorCellRenderer(this.box.getPreferredSize().width));
        }
        if (!this.optional) {
            this.box.setBackground(GUI.WARNING_BACKGROUND_COLOR);
        }
        if (this.defaultTrues.size() > 1) {
            throw new GUIBuildException("Element " + this.getHashKey() + " has multiple default values");
        }
        if (this.defaultTrues.size() == 1) {
            this.box.setSelectedItem(this.defaultTrues.getFirst());
        }
        this.add((Component)this.box, "cell 1 0, growx, ay top, wrap");
    }

    @Override
    public void close() {
        this.box.setSelectedIndex(0);
    }

    @Override
    public String getValue() {
        if (this.box.getSelectedIndex() != 0) {
            int n = this.box.getSelectedIndex() - 1;
            if (n < 0) {
                return "";
            }
            return this.values[n];
        }
        if (!this.isOptional()) {
            JOptionPane.showMessageDialog(null, "No option was selected for " + this.getKey() + " (section '" + this.getSection().toUpperCase() + "')" + ".\nA value is required. Your .ini-file is probably incorrect.", "Problem when building .ini file", 2);
        }
        return null;
    }

    @Override
    public synchronized void set(HashMap hashMap, String string, String string2) {
        this.doSet = true;
        this.setKey = string;
        this.setValue = string2;
        this.setMap = hashMap;
        if (!hashMap.containsKey(this.hashKey)) {
            return;
        }
        String string3 = ((String)hashMap.get(this.hashKey)).toUpperCase();
        for (int i = 0; i < this.values.length; ++i) {
            if (!string3.equals(this.values[i].toUpperCase())) continue;
            this.box.setSelectedIndex(i + 1);
            break;
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        this.help.setText("");
        if (this.box.getSelectedIndex() > 0 && this.helptexts[this.box.getSelectedIndex() - 1] != null) {
            this.help.setText("<html>" + this.helptexts[this.box.getSelectedIndex() - 1] + "</html>");
        } else if (this.helptext != null) {
            this.help.setText("<html>" + this.helptext + "</html>");
        }
        String string = (String)itemEvent.getItem();
        if (string == "") {
            if (!this.optional) {
                this.box.setBackground(GUI.WARNING_BACKGROUND_COLOR);
            }
        } else {
            if (!this.optional) {
                this.box.setBackground(GUI.NORMAL_BACKGROUND_COLOR);
            }
            super.handleItemEvent(itemEvent, string, this.doSet, this.setMap, this.setKey, this.setValue);
            this.doSet = false;
            this.setKey = null;
            this.setMap = null;
            this.setValue = null;
        }
    }
}

