%MASK class definition
%
%   Usage:
%      mask=mask();

classdef mask
	properties (SetAccess=public) 
		groundedice_levelset = NaN;
		ice_levelset         = NaN;
	end
	methods (Static)
		function obj = loadobj(obj) % {{{
			% This function is directly called by matlab when a model object is
			% loaded. Update old properties here

			%2014 February 5th
			if numel(obj.ice_levelset)>1 & all(obj.ice_levelset>=0),
				disp('WARNING: md.mask.ice_levelset>=0, you probably need to change the sign of this levelset');
			end

		end% }}}
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- mask -->');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','<parameter key ="groundedice_levelset" type="',class(obj.groundedice_levelset),'" default="',obj.groundedice_levelset,'">','     <section name="mask" />','     <help> is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if &amp;lt; 0 </help>','</parameter>');
            fprintf(fid,'%s%s%s%s%s\n%s\n%s\n','<parameter key ="ice_levelset" type="',class(obj.ice_levelset),'" default="',obj.ice_levelset,'">','     <section name="mask" />','     <help> presence of ice if > 0, icefront position if = 0, no ice if &amp;lt; 0 </help>','</parameter>');
		end % }}}
		function obj = mask(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','mask.groundedice_levelset','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','mask.ice_levelset'        ,'size',[md.mesh.numberofvertices 1]);
			%isice=(md.mask.ice_levelset>0);
			%if any(sum(isice(md.mesh.elements),2)==0),
		%		warning('elements with no ice not implemented yet, each element should have at least one vertex with md.mask.ice_levelset > 0');
		%	end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   masks:'));

			fielddisplay(obj,'groundedice_levelset','is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if < 0');
			fielddisplay(obj,'ice_levelset','presence of ice if < 0, icefront position if = 0, no ice if > 0');
		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','groundedice_levelset','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','ice_levelset','format','DoubleMat','mattype',1);

			% get mask of vertices of elements with ice
			isice=md.mask.ice_levelset<=0.;
			vlist = zeros(md.mesh.numberofvertices,1);
			pos=find(sum(isice(md.mesh.elements),2)>0);
			vlist(md.mesh.elements(pos,:))=1;
			WriteData(fid,'data',vlist,'enum',IceMaskNodeActivationEnum(),'format','DoubleMat','mattype',1);

		end % }}}
	end
end
