%BASAL FORCINGS class definition
%
%   Usage:
%      basalforcings=basalforcings();

classdef basalforcings
	properties (SetAccess=public) 
		melting_rate             = NaN;
		melting_rate_correction  = NaN;
		geothermalflux           = NaN;
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- basalforcings -->');
			 fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="melting_rate" type="',            class(obj.melting_rate),'" default="',              num2str(obj.melting_rate),'">',              '     <section name="basalforcings" />','     <help> basal melting rate (positive if melting) [m/yr] </help>','</parameter>');
             fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="melting_rate_correction" type="', class(obj.melting_rate_correction),'" default="',   num2str(obj.melting_rate_correction),'">',   '     <section name="basalforcings" />','     <help> additional melting applied to compensate for dh/dt [m/yr] </help>','</parameter>');
             fprintf(fid,'%s%s%s%s%s\n%s\n%s\n',        '<parameter key ="geothermalflux" type="',          class(obj.geothermalflux),'" default="',            num2str(obj.geothermalflux),'">',            '     <section name="basalforcings" />','     <help> geothermal heat flux [W/m^2] </help>','</parameter>');
             
        end % }}}
		function obj = basalforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = initialize(self,md) % {{{

			if isnan(self.melting_rate),
				self.melting_rate=zeros(md.mesh.numberofvertices,1);
				disp('      no basalforcings.melting_rate specified: values set as zero');
			end

		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses) & ~(solution==TransientSolutionEnum() & md.transient.ismasstransport==0),
				md = checkfield(md,'fieldname','basalforcings.melting_rate','NaN',1,'forcing',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','basalforcings.melting_rate','NaN',1,'size',[md.mesh.numberofvertices 1]);
			end
			if ismember(ThermalAnalysisEnum(),analyses) & ~(solution==TransientSolutionEnum() & md.transient.isthermal==0),
				md = checkfield(md,'fieldname','basalforcings.melting_rate','NaN',1,'forcing',1);
				md = checkfield(md,'fieldname','basalforcings.geothermalflux','NaN',1,'forcing',1,'>=',0);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   basal forcings parameters:'));

			fielddisplay(obj,'melting_rate','basal melting rate (positive if melting) [m/yr]');
			fielddisplay(obj,'melting_rate_correction','additional melting applied to compensate for dh/dt [m/yr]');
			fielddisplay(obj,'geothermalflux','geothermal heat flux [W/m^2]');

		end % }}}
		function marshall(obj,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'object',obj,'fieldname','melting_rate','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
			WriteData(fid,'object',obj,'fieldname','melting_rate_correction','format','DoubleMat','mattype',1,'scale',1./yts);
			WriteData(fid,'object',obj,'fieldname','geothermalflux','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1);
		end % }}}
	end
end
