/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

/*Headers:*/
/*{{{*/
#include "./Element.h"
#include "./ElementHook.h"
#include "./TriaRef.h"
class Parameters;
class Inputs;
class IoModel;
class Results;
class Node;
class Material;
class Matpar;
class Seg;
class ElementMatrix;
class ElementVector;
class Vertex;
class GaussTria;

#include "../../shared/Exceptions/exceptions.h"
#include "../../shared/Enum/Enum.h"
/*}}}*/

class Tria: public Element,public ElementHook,public TriaRef{

	public:

		/*Tria constructors, destructors {{{*/
		Tria(){};
		Tria(int tria_id,int tria_sid,int i, IoModel* iomodel,int nummodels);
		~Tria();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		int     ObjectEnum();
		Object *copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type);
		#ifdef _HAVE_DAKOTA_
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nows, int ncols, int name, int type);
		#endif
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Element virtual functions definitions: {{{*/
		IssmDouble  CharacteristicLength(void);
		void        ComputeBasalStress(Vector<IssmDouble>* sigma_b);
		void        ComputeSigmaNN();
		void        ComputeStrainRate(Vector<IssmDouble>* eps);
		void        ComputeStressTensor();
		void        ComputeDeviatoricStressTensor();
		void        ComputeSurfaceNormalVelocity();
		void        Configure(Elements* elements,Loads* loads,Nodes* nodesin,Vertices* verticesin,Materials* materials,Parameters* parameters);
		void        SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Materials* materials,Parameters* parameters);
		void        Delta18oParameterization(void);
		void        ElementSizes(IssmDouble* hx,IssmDouble* hy,IssmDouble* hz);
		void        FSContactMigration(Vector<IssmDouble>* vertexgrounded,Vector<IssmDouble>* vertexfloating);
		int         FiniteElement(void);
		Element*    GetUpperElement(void){_error_("not implemented yet");};
	  	Element*    GetLowerElement(void){_error_("not implemented yet");};
	  	Element*    GetSurfaceElement(void){_error_("not implemented yet");};
		Element*    GetBasalElement(void){_error_("not implemented yet");};
		void        GetGroundedPart(int* point1,IssmDouble* fraction1, IssmDouble* fraction2,bool* mainlyfloating);
		IssmDouble  GetGroundedPortion(IssmDouble* xyz_list);
		int         GetNodeIndex(Node* node);
		int         GetNumberOfNodes(void);
		int         GetNumberOfVertices(void);
		bool        IsOnBase();
		bool        IsOnSurface();
		bool        HasEdgeOnBase();
		bool        HasEdgeOnSurface();
		void        EdgeOnSurfaceIndices(int* pindex1,int* pindex);
		void        EdgeOnBaseIndices(int* pindex1,int* pindex);
		int         EdgeOnBaseIndex();
		int         EdgeOnSurfaceIndex();
		bool        IsNodeOnShelfFromFlags(IssmDouble* flags);
		int         NumberofNodesVelocity(void);
		int         NumberofNodesPressure(void);
		void        GetSolutionFromInputsOneDof(Vector<IssmDouble>* solution,int enum_type);
		void        GetVerticesCoordinatesBase(IssmDouble** pxyz_list);
		void        GetVerticesCoordinatesTop(IssmDouble** pxyz_list);
		void        InputDepthAverageAtBase(int enum_type,int average_enum_type);
		void        InputDuplicate(int original_enum,int new_enum);
		void        InputScale(int enum_type,IssmDouble scale_factor);
		void        MaterialUpdateFromTemperature(void){_error_("not implemented yet");};
		int         NodalValue(IssmDouble* pvalue, int index, int natureofdataenum);
		void        PositiveDegreeDay(IssmDouble* pdds,IssmDouble* pds,IssmDouble signorm);
		void        ReduceMatrices(ElementMatrix* Ke,ElementVector* pe);
		void        ResetFSBasalBoundaryCondition(void);
		void	      SmbGradients();
	   Element*    SpawnBasalElement(void);
		Element*    SpawnTopElement(void);
		int         VelocityInterpolation();
		int         PressureInterpolation();
		IssmDouble  SurfaceArea(void);
		void        Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type,int finitelement);
		IssmDouble  TimeAdapt();
		void   ValueP1OnGauss(IssmDouble* pvalue,IssmDouble* values,Gauss* gauss);
		void   ValueP1DerivativesOnGauss(IssmDouble* dvalue,IssmDouble* values,IssmDouble* xyz_list,Gauss* gauss);
		int         VertexConnectivity(int vertexindex);
		void   VerticalSegmentIndices(int** pindices,int* pnumseg){_error_("not implemented yet");};
		void        ZeroLevelsetCoordinates(IssmDouble** pxyz_zero,IssmDouble* xyz_list,int levelsetenum);
		void	    GetIcefrontCoordinates(IssmDouble** pxyz_front,IssmDouble* xyz_list,int levelsetenum);
	    void        GetNormalFromLSF(IssmDouble *pnormal);
		bool        IsZeroLevelset(int levelset_enum);
		bool		IsIcefront(void);

		void       AverageOntoPartition(Vector<IssmDouble>* partition_contributions,Vector<IssmDouble>* partition_areas,IssmDouble* vertex_response,IssmDouble* qmu_part);
		IssmDouble IceVolume(void);
		IssmDouble IceVolumeAboveFloatation(void);
		IssmDouble TotalSmb(void);
		void       MinVel(IssmDouble* pminvel);
		void       MinVx(IssmDouble* pminvx);
		void       MinVy(IssmDouble* pminvy);
		void       MinVz(IssmDouble* pminvz);
		IssmDouble MassFlux(IssmDouble* segment);
		IssmDouble MassFlux(IssmDouble x1,IssmDouble y1, IssmDouble x2, IssmDouble y2,int segment_id);
		void       MaxAbsVx(IssmDouble* pmaxabsvx);
		void       MaxAbsVy(IssmDouble* pmaxabsvy);
		void       MaxAbsVz(IssmDouble* pmaxabsvz);
		void       ElementResponse(IssmDouble* presponse,int response_enum);
		void       MaxVel(IssmDouble* pmaxvel);
		void       MaxVx(IssmDouble* pmaxvx);
		void       MaxVy(IssmDouble* pmaxvy);
		void       MaxVz(IssmDouble* pmaxvz);
		IssmDouble Misfit(int modelenum,int observationenum,int weightsenum);
		IssmDouble MisfitArea(int weightsenum);

		#ifdef _HAVE_GIA_
		void   GiaDeflection(Vector<IssmDouble>* wg,Vector<IssmDouble>* dwgdt,IssmDouble* x,IssmDouble* y);
		#endif

		IssmDouble DragCoefficientAbsGradient(void);
		void       GradientIndexing(int* indexing,int control_index);
		void       Gradj(Vector<IssmDouble>* gradient,int control_type,int control_index);
		void       GradjBGradient(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDGradient(Vector<IssmDouble>* gradient,int control_index);
		void       GradjBSSA(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDSSA(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDragSSA(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDragFS(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDragGradient(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDhDtBalancedthickness(Vector<IssmDouble>* gradient,int control_index);
		void       GradjVxBalancedthickness(Vector<IssmDouble>* gradient,int control_index);
		void       GradjVyBalancedthickness(Vector<IssmDouble>* gradient,int control_index);
		void       GradjThicknessBalancethicknessSoft(Vector<IssmDouble>* gradient,int control_index);
		void       GetVectorFromControlInputs(Vector<IssmDouble>* gradient,int control_enum,int control_index,const char* data);
		void       SetControlInputsFromVector(IssmDouble* vector,int control_enum,int control_index);
		void       ControlInputGetGradient(Vector<IssmDouble>* gradient,int enum_type,int control_index);
		void       ControlInputScaleGradient(int enum_type,IssmDouble scale);
		void       ControlInputSetGradient(IssmDouble* gradient,int enum_type,int control_index);
		void       ControlToVectors(Vector<IssmPDouble>* vector_control, Vector<IssmPDouble>* vector_gradient,int control_enum);
		IssmDouble RheologyBbarAbsGradient(void);
		IssmDouble ThicknessAbsMisfit(void);
		IssmDouble SurfaceAbsVelMisfit(void);
		IssmDouble ThicknessAbsGradient(void);
		IssmDouble ThicknessAlongGradient(void);
		IssmDouble ThicknessAcrossGradient(void);
		IssmDouble BalancethicknessMisfit(void);
		IssmDouble SurfaceRelVelMisfit(void);
		IssmDouble SurfaceLogVelMisfit(void);
		IssmDouble SurfaceLogVxVyMisfit(void);
		IssmDouble SurfaceAverageVelMisfit(void);
		void       InputControlUpdate(IssmDouble scalar,bool save_parameter);

		void   PotentialUngrounding(Vector<IssmDouble>* potential_sheet_ungrounding);
		void   MigrateGroundingLine(IssmDouble* sheet_ungrounding);
		int    UpdatePotentialUngrounding(IssmDouble* vertices_potentially_ungrounding,Vector<IssmDouble>* vec_nodes_on_iceshelf,IssmDouble* nodes_on_iceshelf);

		/*}}}*/
		/*Tria specific routines:{{{*/
		void           AddBasalInput(int input_enum, IssmDouble* values, int interpolation_enum);
		void           AddInput(int input_enum, IssmDouble* values, int interpolation_enum);
		IssmDouble     GetArea(void);
		void           GetAreaCoordinates(IssmDouble *area_coordinates,IssmDouble* xyz_zero,IssmDouble* xyz_list,int numpoints);
		int            GetElementType(void);
		IssmDouble     GetXcoord(Gauss* gauss);
		IssmDouble     GetYcoord(Gauss* gauss);
		IssmDouble     GetZcoord(Gauss* gauss){_error_("not implemented");};
		void           NormalSection(IssmDouble* normal,IssmDouble* xyz_list);
		void           NormalTop(IssmDouble* normal,IssmDouble* xyz_list);
		void           NormalBase(IssmDouble* normal,IssmDouble* xyz_list);
		void           GetInputValue(IssmDouble* pvalue,Node* node,int enumtype);
		void           GetMaterialInputValue(IssmDouble* pvalue,Node* node,int enumtype);
		Node*          GetNode(int node_number);
		void	         InputUpdateFromSolutionOneDof(IssmDouble* solution,int enum_type);
		void	         InputUpdateFromSolutionOneDofCollapsed(IssmDouble* solution,int enum_type){_error_("not implemented yet");};
		void           JacobianDeterminant(IssmDouble*  pJdet, IssmDouble* xyz_list,Gauss* gauss);
		void           JacobianDeterminantLine(IssmDouble* Jdet, IssmDouble* xyz_list,Gauss* gauss){_error_("not implemented yet");};
		void           JacobianDeterminantSurface(IssmDouble*  pJdet, IssmDouble* xyz_list,Gauss* gauss);
		void           JacobianDeterminantBase(IssmDouble* pJdet,IssmDouble* xyz_list_base,Gauss* gauss);
		void           JacobianDeterminantTop(IssmDouble* pJdet,IssmDouble* xyz_list_base,Gauss* gauss);
		IssmDouble     MinEdgeLength(IssmDouble* xyz_list){_error_("not implemented yet");};
		Gauss*         NewGauss(void);
		Gauss*         NewGauss(int order);
      Gauss*         NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order);
      Gauss*         NewGauss(int point1,IssmDouble fraction1,IssmDouble fraction2,bool mainlyfloating,int order);
      Gauss*         NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order_horiz,int order_vert);
		Gauss*         NewGaussBase(int order);
		Gauss*         NewGaussLine(int vertex1,int vertex2,int order){_error_("not implemented yet");};
		Gauss*         NewGaussTop(int order);
		void           NodalFunctions(IssmDouble* basis,Gauss* gauss);
		void           NodalFunctionsP1(IssmDouble* basis,Gauss* gauss){_error_("not implemented yet");};
		void           NodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void           NodalFunctionsP1Derivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss){_error_("not implemented yet");};
		void           NodalFunctionsMINIDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss){_error_("not implemented yet");};
		void           NodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void           NodalFunctionsVelocity(IssmDouble* basis,Gauss* gauss);
		void           NodalFunctionsPressure(IssmDouble* basis,Gauss* gauss);
		void           NodalFunctionsTensor(IssmDouble* basis,Gauss* gauss);
		void	         SetClone(int* minranks);
		void           SetTemporaryElementType(int element_type_in){_error_("not implemented yet");};
		Seg*	         SpawnSeg(int index1,int index2);
		IssmDouble     StabilizationParameter(IssmDouble u, IssmDouble v, IssmDouble w, IssmDouble diameter, IssmDouble kappa){_error_("not implemented yet");};
		void           ViscousHeating(IssmDouble* pphi,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input){_error_("not implemented yet");};

		void UpdateConstraintsExtrudeFromBase(void);
		void UpdateConstraintsExtrudeFromTop(void);

		void           CreateHydrologyWaterVelocityInput(void);
		/*}}}*/

};
#endif  /* _TRIA_H */
