from cmaptools import truncate_colormap
try:
	import pylab as p
	import matplotlib as mpl
	import matplotlib.pyplot as plt
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

def plot_unit(x,y,z,elements,data,is2d,isplanet,datatype,options,ax):
	"""
	PLOT_UNIT - unit plot, display data
	
		Usage:
			plot_unit(x,y,z,elements,data,is2d,isplanet,datatype,options)
	
		See also: PLOTMODEL, PLOT_MANAGER
	"""
	
	#edgecolor
	edgecolor=options.getfieldvalue('edgecolor','None')
	
	#number of colorlevels for plots
	colorlevels=options.getfieldvalue('colorlevels',128)
	
	alpha=options.getfieldvalue('alpha',1)
	
	#colormap
	# default sequential colormap
	defaultmap=truncate_colormap(mpl.cm.gnuplot2,0.1,0.9,128)
	cmap=options.getfieldvalue('colormap',defaultmap)
	if options.exist('cmap_set_over'):
	   over=options.getfieldvalue('cmap_set_over','0.5')
	   cmap.set_over(over)
	if options.exist('cmap_set_under'):
	   under=options.getfieldvalue('cmap_set_under','0.5')
	   cmap.set_under(under)
	
	#normalize colormap if clim/caxis specified
	if options.exist('clim'):
	   lims=options.getfieldvalue('clim',[min(data),max(data)])
	elif options.exist('caxis'):
	   lims=options.getfieldvalue('caxis',[min(data),max(data)])
	else:
	   lims=[min(data),max(data)]
	norm = mpl.colors.Normalize(vmin=lims[0], vmax=lims[1])
	if datatype==1:
	   #element plot
		if is2d:
			tri=ax.tripcolor(x,y,elements,data,colorlevels,cmap=cmap,edgecolors=edgecolor)
		else:
			raise ValueError('plot_unit error: 3D element plot not supported yet')
		return 
	
	elif datatype==2:
		#node plot
		if is2d:
			tri=ax.tricontourf(x,y,elements,data,colorlevels,cmap=cmap,norm=norm,alpha=alpha)
			if edgecolor != 'None':
				ax.triplot(x,y,elements,color=edgecolor)
		else:
			raise ValueError('plot_unit error: 3D node plot not supported yet')
		return
	
	elif datatype==3:
		print 'plot_unit message: quiver plot not implemented yet'
		return
	
	elif datatype==4:
		#P1 patch plot
		print 'plot_unit message: P1 patch plot not implemented yet'
		return
	
	elif datatype==5:
		print 'plot_unit message: P0 patch plot not implemented yet'
		return
	
	else:
		raise ValueError('datatype=%d not supported' % datatype)

