import numpy as npy
from triangle import triangle
from model import model
from setmask import setmask
from parameterize import parameterize
from verbose import verbose
from setflowequation import setflowequation
from generic import generic
from socket import gethostname as oshostname
from solve import solve
from EnumDefinitions import DamageEvolutionSolutionEnum

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf.py')
md.damage.D=0.1*npy.ones((md.mesh.numberofvertices,1))
md.damage.spcdamage=npy.float('nan')*npy.ones((md.mesh.numberofvertices,1))
md.damage.law='pralong'

md.damage.c1=1.e-11
md.damage.c2=0.4
md.damage.c3=1.e-3
md.damage.healing=0.4
md.damage.stress_threshold=1.e5
md.damage.stabilization=1

md.damage.requested_outputs=['default','DamageF']

md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DamageEvolutionSolutionEnum())

field_names=['D','F']
field_tolerances=[1.e-13,1.e-13]
field_values=[\
		md.results.DamageEvolutionSolution.DamageDbar,\
		md.results.DamageEvolutionSolution.DamageF,\
		]
