/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.GUI;
import main.PanelControl;
import main.PanelNode;
import main.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GUIBuilder {
    public static ProgressMonitor monitor;
    public static final String xsd;
    public static String res_filepath;
    public static Document doc;
    public static GUI gui;
    public static PanelControl panelControl;
    public static String application;
    public static String currentConfigFile;
    public static String saveFilePath;

    private static String getFileExtension(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return "";
        }
        String string3 = string.substring(n + 1);
        int n2 = string3.lastIndexOf(".");
        if (n2 == -1) {
            return "";
        }
        return string3.substring(n2 + 1);
    }

    public static void main(String[] stringArray) throws GUIBuildException {
        new GUIBuilder();
        if (stringArray.length != 0 && stringArray[0].length() > 0) {
            res_filepath = stringArray[0];
        }
        GUIBuilder.buildGUI(res_filepath);
    }

    public GUIBuilder() throws GUIBuildException {
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Inishell");
            System.setProperty("apple.awt.brushMetalLook", "true");
        }
        gui = new GUI();
    }

    public static void setComments(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        panelControl.setComments(hashMap, hashMap2);
    }

    public static void buildGUI(String string) throws GUIBuildException {
        currentConfigFile = string;
        doc = XMLHelper.readXML(string, xsd);
        doc = XMLHelper.resolveReferences(doc);
        application = doc.getDocumentElement().getAttribute("application");
        gui.setApplicationForTitle(application);
        panelControl = new PanelControl();
        Element element = doc.getDocumentElement();
        GUIBuilder.recursiveBuild(element, null, false);
    }

    public static void setValues(final HashMap<String, String> hashMap, final HashMap<String, String> hashMap2, final HashMap<String, String> hashMap3) {
        if (hashMap == null) {
            return;
        }
        monitor = new ProgressMonitor(gui, "Loading INI file", "0 out of " + GUIBuilder.panelControl.order.size() + " sections loaded", 0, GUIBuilder.panelControl.order.size());
        monitor.setMillisToPopup(0);
        Thread thread = new Thread(){

            @Override
            public void run() {
                int n = 0;
                try {
                    int n2 = GUIBuilder.closeFile();
                    if (n2 == 2) {
                        return;
                    }
                    monitor.setProgress(n);
                    GUIBuilder.buildGUI(currentConfigFile);
                }
                catch (GUIBuildException gUIBuildException) {
                    gUIBuildException.printStackTrace();
                }
                gui.setEnabled(false);
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = new HashSet<String>();
                Iterator<Map.Entry<String, TreeMap<String, ControlledPanel>>> iterator = GUIBuilder.panelControl.panels.entrySet().iterator();
                while (iterator.hasNext()) {
                    monitor.setProgress(++n);
                    monitor.setNote(n + " out of " + GUIBuilder.panelControl.order.size() + " sections loaded");
                    if (monitor.isCanceled()) {
                        monitor.close();
                        gui.setEnabled(true);
                        break;
                    }
                    Map.Entry<String, TreeMap<String, ControlledPanel>> entry = iterator.next();
                    Object object = (TreeMap)entry.getValue();
                    ArrayList arrayList = new ArrayList(hashMap.keySet());
                    String string = ((String)entry.getKey()).toUpperCase() + "::";
                    GUIBuilder.filterList(string, arrayList);
                    LinkedList<ControlledPanel> linkedList = new LinkedList<ControlledPanel>();
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    LinkedList linkedList3 = new LinkedList();
                    do {
                        linkedList.clear();
                        linkedList2.clear();
                        linkedList3.clear();
                        Iterator iterator2 = ((TreeMap)object).entrySet().iterator();
                        while (iterator2.hasNext()) {
                            ControlledPanel controlledPanel = (ControlledPanel)iterator2.next().getValue();
                            String string2 = controlledPanel.getHashKey();
                            string2 = string2.replace("%", "[a-zA-Z0-9_]+");
                            string2 = string2.replace("#", "[1-9]+[0-9]*");
                            for (String string3 : arrayList) {
                                if (hashSet.contains(string3) || !string3.matches(string2)) continue;
                                linkedList.add(controlledPanel);
                                linkedList2.add(string3);
                                linkedList3.add(hashMap.get(string3));
                                hashSet.add(string3);
                            }
                        }
                        for (int i = 0; i < linkedList.size(); ++i) {
                            ((ControlledPanel)linkedList.get(i)).set(hashMap, (String)linkedList2.get(i), (String)linkedList3.get(i));
                        }
                    } while (linkedList.size() != 0);
                    if (n != GUIBuilder.panelControl.order.size()) continue;
                    gui.setEnabled(true);
                }
                for (Object object : hashMap.keySet()) {
                    if (hashSet.contains(object)) continue;
                    hashSet2.add((String)object);
                    panelControl.setUnusedKeys((String)object, (String)hashMap.get(object));
                }
                GUIBuilder.setComments(hashMap2, hashMap3);
            }
        };
        thread.start();
    }

    private static void filterList(String string, List<String> list) {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    public static int closeFile() {
        int n = JOptionPane.showConfirmDialog(new JPanel(), "You will lose all changes made to the current ini-file. Do you want this?", "Inishell is already open for " + application, 2);
        if (n == 0) {
            gui.closeAllTabs();
            GUI.rootNode = new PanelNode("");
            application = null;
            doc = null;
            panelControl = null;
        }
        return n;
    }

    public static void control(ControlledPanel controlledPanel) {
        String string = controlledPanel.getSection();
        panelControl.put(string, controlledPanel);
    }

    public static void recursiveBuild(Element element, ControlledPanel controlledPanel, boolean bl) throws GUIBuildException {
        GUIBuilder.recursiveBuild(element, controlledPanel, bl, null, null, null);
    }

    public static void recursiveBuild(Element element, ControlledPanel controlledPanel, boolean bl, HashMap hashMap, String string, String string2) throws GUIBuildException {
        Element[] elementArray;
        String[] stringArray = new String[]{"parameter", "frame"};
        for (Element element2 : elementArray = XMLHelper.getElementArray(element, stringArray)) {
            ControlledPanel controlledPanel2;
            String string3 = element2.getAttribute("section");
            if (!panelControl.contains(string3, element2.getAttribute("key"))) {
                controlledPanel2 = ControlledPanel.createSingleParameterPanel(element2, controlledPanel);
                controlledPanel2.setKey(controlledPanel2.getKey());
                if (!element2.getAttribute("template").equals("true")) {
                    if (bl) {
                        controlledPanel2.set(hashMap, controlledPanel2.getKey(), string2);
                    }
                    gui.addToTab(controlledPanel2, string3, controlledPanel);
                    GUIBuilder.control(controlledPanel2);
                }
            } else {
                controlledPanel2 = panelControl.get(string3, element2.getAttribute("key"));
            }
            controlledPanel2.hold();
            GUIBuilder.recursiveBuild(element2, controlledPanel2, bl);
        }
        gui.validate();
    }

    public static void recursiveDestruct(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        Element[] elementArray;
        for (Element element2 : elementArray = XMLHelper.getElementArray(element, "parameter")) {
            String string = element2.getAttribute("section");
            ControlledPanel controlledPanel2 = panelControl.get(string, element2.getAttribute("key"));
            GUIBuilder.recursiveDestruct(element2, controlledPanel2);
            controlledPanel2.release();
            controlledPanel2.close();
            if (controlledPanel2.isNeeded()) continue;
            gui.removeFromTab(controlledPanel2, string, controlledPanel);
        }
        gui.validate();
    }

    public static void printIOFile() throws IOException, GUIBuildException {
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(".ini files", "ini");
        JFileChooser jFileChooser = new JFileChooser(saveFilePath);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showSaveDialog(new JPanel());
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            String string2 = GUIBuilder.getFileExtension(string).toLowerCase();
            if (!string2.equals("ini")) {
                string = string + ".ini";
            }
            if (jFileChooser.getSelectedFile().isDirectory()) {
                return;
            }
            saveFilePath = jFileChooser.getSelectedFile().getParent();
            panelControl.printToFile(string);
        }
    }

    static {
        xsd = GUIBuilder.class.getClassLoader().getResource("resources/config_schema-0.1.1.xsd").toString();
        res_filepath = GUIBuilder.class.getClassLoader().getResource("resources/default_config.xml").toString();
        saveFilePath = System.getProperty("user.dir");
    }
}

