/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import gui_elements.OptionPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import main.XMLHelper;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CombinedPanel
extends OptionPanel {
    private static final long serialVersionUID = -6751282938445852408L;
    private final LinkedList<JComponent> valueComponents;

    public CombinedPanel(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        super(element, controlledPanel, false);
        int n = 200;
        this.setLayout(new MigLayout("gapx 6, wrap 8, ins n 5 n n", "[" + (n -= this.getHierarchy() * 5) + "!][78!][78!][78!][78!][78!][78!][20!][200:400:400]", ""));
        this.add((Component)this.jlabel, "gapleft " + this.getHierarchy() * 5);
        this.add((Component)this.help, "cell 8 0, wrap");
        this.valueComponents = new LinkedList();
        Element[] elementArray = XMLHelper.getElementArray(element, "option");
        boolean bl = false;
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setGroupingUsed(false);
        DecimalFormat decimalFormat2 = (DecimalFormat)DecimalFormat.getIntegerInstance();
        decimalFormat2.setGroupingUsed(false);
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < elementArray.length; ++i) {
            int n4;
            Type type = Type.valueOf(elementArray[i].getAttribute("type").toUpperCase());
            String string = elementArray[i].getAttribute("value");
            String string2 = elementArray[i].getAttribute("label");
            JComponent jComponent = null;
            JLabel jLabel = null;
            NodeList nodeList = elementArray[i].getChildNodes();
            switch (type) {
                case INTEGER: {
                    jComponent = new JFormattedTextField(decimalFormat2);
                    ((JFormattedTextField)jComponent).setColumns(8);
                    if (string == null || string.equals("")) break;
                    ((JFormattedTextField)jComponent).setValue(new Integer(string));
                    break;
                }
                case DECIMAL: {
                    jComponent = new JFormattedTextField(decimalFormat);
                    ((JFormattedTextField)jComponent).setColumns(8);
                    if (string == null || string.equals("")) break;
                    ((JFormattedTextField)jComponent).setValue(new Double(string));
                    break;
                }
                case STRING: {
                    jComponent = new JTextField(10);
                    ((JTextField)jComponent).setText(string);
                    break;
                }
                case CHOICE: {
                    jComponent = new JCheckBox(elementArray[i].getAttribute("value"));
                    ((JCheckBox)jComponent).addItemListener(this);
                    break;
                }
                case DROPDOWN: {
                    jComponent = new JComboBox();
                    for (n4 = 0; n4 < nodeList.getLength(); ++n4) {
                        if (nodeList.item(n4).getNodeType() != 1) continue;
                        ((JComboBox)jComponent).addItem(((Element)nodeList.item(n4)).getAttribute("value"));
                    }
                    ((JComboBox)jComponent).setSelectedItem(elementArray[i].getAttribute("value"));
                    ((JComboBox)jComponent).addItemListener(this);
                }
            }
            n4 = 1;
            if (string2 != null && !string2.equals("")) {
                if (string2.length() > 12) {
                    n4 = 2;
                }
                if (n3 + n4 >= 7) {
                    n3 = 1;
                    ++n2;
                }
                jLabel = new JLabel(string2);
                this.valueComponents.add(jLabel);
                this.add((Component)jLabel, "cell " + n3 + " " + n2 + " " + n4 + " 1");
                n3 += n4;
                n4 = 1;
                jLabel.setVisible(true);
            }
            if (n3 >= 7) {
                n3 = 1;
                ++n2;
            }
            this.add((Component)jComponent, "cell " + n3 + " " + n2 + " " + n4 + " 1");
            ++n3;
            this.valueComponents.add(jComponent);
            jComponent.setVisible(true);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
        if (!hashMap.containsKey(this.hashKey)) {
            return;
        }
        String string3 = (String)hashMap.get(this.hashKey);
        if (string3 == null) {
            return;
        }
        String[] stringArray = string3.split("\\s+");
        int n = 0;
        for (JComponent jComponent : this.valueComponents) {
            Object object;
            boolean bl = false;
            if (stringArray.length <= n) break;
            if (jComponent.getClass() == JCheckBox.class) {
                object = ((JCheckBox)jComponent).getText();
                if (stringArray[n].equals(object)) {
                    ((JCheckBox)jComponent).setSelected(true);
                    bl = true;
                }
            } else if (jComponent.getClass() == JComboBox.class) {
                object = (JComboBox)jComponent;
                for (int i = 0; i < ((JComboBox)object).getItemCount(); ++i) {
                    String string4 = (String)((JComboBox)object).getItemAt(i);
                    if (!string4.equals(stringArray[n])) continue;
                    ((JComboBox)object).setSelectedIndex(i);
                    bl = true;
                }
            } else if (jComponent.getClass() == JTextField.class) {
                ((JTextField)jComponent).setText(stringArray[n]);
                bl = true;
            } else if (jComponent.getClass() == JFormattedTextField.class) {
                ((JFormattedTextField)jComponent).setText(stringArray[n]);
                bl = true;
            }
            if (jComponent.getClass() == JLabel.class || !bl) continue;
            ++n;
        }
    }

    @Override
    public String getValue() {
        String string = "";
        for (JComponent jComponent : this.valueComponents) {
            if (jComponent.getClass() == JTextField.class) {
                string = string + ((JTextField)jComponent).getText();
            } else if (jComponent.getClass() == JFormattedTextField.class) {
                string = string + ((JFormattedTextField)jComponent).getText();
            } else if (jComponent.getClass() == JCheckBox.class) {
                if (((JCheckBox)jComponent).isSelected()) {
                    string = string + ((JCheckBox)jComponent).getText();
                }
            } else if (jComponent.getClass() == JComboBox.class) {
                string = string + (String)((JComboBox)jComponent).getSelectedItem();
            }
            if (string.length() <= 0) continue;
            string = string + " ";
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = null;
        if (itemEvent.getItemSelectable().getClass() == JCheckBox.class) {
            string = ((JCheckBox)itemEvent.getItemSelectable()).getText();
            super.handleItemEvent(itemEvent, string);
        } else if (itemEvent.getItemSelectable().getClass() == JComboBox.class) {
            string = (String)((JComboBox)itemEvent.getItemSelectable()).getSelectedItem();
        }
    }

    static enum Type {
        CHOICE,
        INTEGER,
        DECIMAL,
        STRING,
        DROPDOWN;

    }
}

