/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import main.GUIBuilder;
import main.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SelectorPanel
extends ControlledPanel
implements ActionListener {
    private static final long serialVersionUID = 8610877538909126920L;
    String[] parameters;
    JButton addButton = new JButton("+");
    JButton removeButton;
    Element template;
    String templateKey = "";
    HashMap<String, ControlledPanel> mapOfParameters;
    ControlledPanel cp = null;

    public SelectorPanel(Element element, ControlledPanel controlledPanel) {
        super(element, controlledPanel);
        this.add((Component)this.addButton, "cell 1 0, split 2, grow");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("-");
        this.add((Component)this.removeButton, "cell 1 0, grow, wrap");
        this.removeButton.addActionListener(this);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (nodeList.item(i).getNodeType() != 1 || !(element2 = (Element)nodeList.item(i)).getAttribute("template").equals("true")) continue;
            this.template = (Element)element2.cloneNode(true);
            this.templateKey = this.template.getAttribute("key");
            this.template.setAttribute("template", "false");
        }
        Element[] elementArray = XMLHelper.getElementArray(element, "option");
        this.parameters = new String[elementArray.length + 1];
        for (int i = 0; i < elementArray.length; ++i) {
            this.parameters[i] = elementArray[i].getAttribute("value");
        }
        this.parameters[elementArray.length] = "Other...";
        this.key = this.templateKey;
        this.hashKey = this.getSection().toUpperCase() + "::" + this.getKey().toUpperCase();
        this.mapOfParameters = new HashMap();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.remove();
        }
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
        String string3 = this.section.toUpperCase() + "::" + this.templateKey.toUpperCase().replace("%", "([a-zA-Z0-9_]+)");
        string3 = string3.replace("#", "[1-9]+[0-9]*");
        String string4 = string.replaceAll(string3, "$1");
        String string5 = string.replaceAll(string3, "$0");
        boolean bl = true;
        if (this.mapOfParameters.get(string4) != null) {
            bl = false;
        }
        if (bl) {
            ControlledPanel controlledPanel;
            this.cp = controlledPanel = this.add(string4, true, hashMap, string, string2);
            if (controlledPanel != null) {
                controlledPanel.set(hashMap, string, string2);
            }
        } else if (this.cp != null) {
            this.cp.set(hashMap, string, string2);
        }
    }

    public void add() {
        String string = "";
        String string2 = "Other...";
        if (this.parameters.length > 1) {
            string2 = (String)JOptionPane.showInputDialog(this, "Add a parameter", "Add", 3, null, this.parameters, null);
        }
        if (string2 == null) {
            return;
        }
        string = string2.equals("Other...") ? JOptionPane.showInputDialog(this, (Object)"Enter the name of a meteo parameter\n(e.g. VW_AVG, P2") : string2;
        this.add(string, false, null, null, null);
    }

    public ControlledPanel add(String string, boolean bl, HashMap hashMap, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.mapOfParameters.get(string = string.toUpperCase()) != null) {
            return null;
        }
        Element element = (Element)this.template.cloneNode(true);
        this.recursiveKeyReplace(element, string);
        this.element.appendChild(element);
        ControlledPanel controlledPanel = null;
        try {
            controlledPanel = ControlledPanel.createSingleParameterPanel(element, this);
            controlledPanel.setKey(controlledPanel.getKey());
            GUIBuilder.gui.addToTab(controlledPanel, this.section, this);
            controlledPanel.hold();
            GUIBuilder.control(controlledPanel);
            GUIBuilder.recursiveBuild(element, this, bl, hashMap, string2, string3);
            this.mapOfParameters.put(string, controlledPanel);
        }
        catch (GUIBuildException gUIBuildException) {
            gUIBuildException.printStackTrace();
        }
        this.invalidate();
        return controlledPanel;
    }

    @Override
    public void close() {
    }

    @Override
    public String getValue() {
        return null;
    }

    public void remove() {
        if (this.mapOfParameters.size() == 0) {
            return;
        }
        String string = (String)JOptionPane.showInputDialog(this, "Remove a parameter", "Remove", 3, null, this.mapOfParameters.keySet().toArray(), null);
        if (string == null) {
            return;
        }
        String string2 = this.templateKey.replaceAll("%", string);
        Element element = XMLHelper.getCertainChildElement(this.element, "parameter", "key", string2);
        if (element == null) {
            return;
        }
        try {
            GUIBuilder.recursiveDestruct(element, this);
            this.element.removeChild(element);
            ControlledPanel controlledPanel = GUIBuilder.panelControl.get(this.section, string2);
            controlledPanel.release();
            controlledPanel.close();
            if (!controlledPanel.isNeeded()) {
                GUIBuilder.gui.removeFromTab(controlledPanel, this.section, this);
            }
            this.mapOfParameters.remove(string);
        }
        catch (GUIBuildException gUIBuildException) {
            gUIBuildException.printStackTrace();
        }
        this.invalidate();
    }

    private void recursiveKeyReplace(Element element, String string) {
        if (element.hasAttribute("key")) {
            element.setAttribute("key", element.getAttribute("key").replaceAll("%", string));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            this.recursiveKeyReplace((Element)nodeList.item(i), string);
        }
    }
}

