/*! \file ExtrudeFromTopAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _ExtrudeFromTopAnalysis_
#define _ExtrudeFromTopAnalysis_

/*Headers*/
#include "./Analysis.h"

class ExtrudeFromTopAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int domaintype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		void           Core(FemModel* femmodel);
		ElementVector* CreateDVector(Element* element);
		ElementMatrix* CreateJacobianMatrix(Element* element);
		ElementMatrix* CreateKMatrix(Element* element);
		ElementMatrix* CreateKMatrixVolume(Element* element);
		ElementMatrix* CreateKMatrixSurface(Element* element);
		ElementMatrix* CreateKMatrixBed(Element* element);
		ElementVector* CreatePVector(Element* element);
		void GetB(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void UpdateConstraints(FemModel* femmodel);
};
#endif
