/*! \file HydrologyDCEfficientAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _HydrologyDCEfficientAnalysis_
#define _HydrologyDCEfficientAnalysis_

/*Headers*/
#include "./Analysis.h"
class Node;
class Input;
class HydrologyDCEfficientAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int meshxdim,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		void           Core(FemModel* femmodel);
		ElementVector* CreateDVector(Element* element);
		ElementMatrix* CreateJacobianMatrix(Element* element);
		ElementMatrix* CreateKMatrix(Element* element);
		ElementVector* CreatePVector(Element* element);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void UpdateConstraints(FemModel* femmodel);

		/*Intermediaries*/
		void GetB(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		IssmDouble EplSpecificStoring(Element* element);
		IssmDouble SedimentStoring(Element* element);
		IssmDouble GetHydrologyKMatrixTransfer(Element* element, Gauss* gauss, Input* epl_thick_input, Input* sed_head_input, Input* epl_head_input, Input* sed_trans_input, Input* residual_input);
		IssmDouble GetHydrologyPVectorTransfer(Element* element, Gauss* gauss, Input* epl_thick_input, Input* sed_head_input, Input* epl_head_input, Input* sed_trans_input, Input* residual_input);
		void HydrologyEPLGetMask(Vector<IssmDouble>* vec_mask,Element* element);
		void HydrologyEPLGetActive(Vector<IssmDouble>* active_vec, Element* element);
		void GetHydrologyDCInefficientHmax(IssmDouble* ph_max,Element* element, Node* innode);
		void ComputeEPLThickness(FemModel* femmodel);
};
#endif
