/*! \file StressbalanceSIAAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _StressbalanceSIAAnalysis_
#define _StressbalanceSIAAnalysis_

/*Headers*/
#include "./Analysis.h"

class StressbalanceSIAAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int meshxdim,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		void           Core(FemModel* femmodel);
		ElementVector* CreateDVector(Element* element);
		ElementMatrix* CreateJacobianMatrix(Element* element);
		ElementMatrix* CreateKMatrix(Element* element);
		ElementMatrix* CreateKMatrix2D(Element* element);
		ElementMatrix* CreateKMatrix3D(Element* element);
		ElementVector* CreatePVector(Element* element);
		ElementVector* CreatePVector2D(Element* element);
		ElementVector* CreatePVector3D(Element* element);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void UpdateConstraints(FemModel* femmodel);
};
#endif
