package gov.nasa.jpl.issm;

import java.net.URI;

import android.os.Bundle;
import android.os.Handler;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.widget.Button;

public class ISSMWebActivity extends Activity {

	// URL of the index page of the ISSM web application
	private String srcPath = "http://issm.jpl.nasa.gov/externalicelab/html/index.html";
	private String offPath = "file:///android_asset/externalicelab/index.html";
	private final String KEY = "mode";
	private String issmFolder = "";
	private int MODE;
	// private String srcPath =
	// "http://www.csupomona.edu/~lannguyen/ISSM_WEB/html/index.html";
	private WebView myWebView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		setContentView(R.layout.activity_issmweb_online);
		MODE = getIntent().getExtras().getInt(KEY);

		myWebView = (WebView) findViewById(R.id.issmWeb);
		myWebView.setWebViewClient(new MyWebViewClient() {

			@Override
			public boolean shouldOverrideUrlLoading(WebView view, String url) {
				if (MODE != 0) {
					if (url.startsWith("http")
							&& !url.contains("http://thwaites.jpl.nasa.gov/fastcgi/visl-solve.py?callbacks")) {
						myWebView.stopLoading();
						new AlertDialog.Builder(ISSMWebActivity.this)
								.setTitle("Error!")
								.setMessage(
										"Option requires online mode. Exit and enable connection to access the option.")
								.setCancelable(false)
								.setPositiveButton("Okay",
										new DialogInterface.OnClickListener() {
											public void onClick(
													DialogInterface dialog,
													int id) {
												if (!myWebView.getOriginalUrl()
														.equals(offPath)) {
													myWebView.loadUrl(offPath);
												}
											}
										}).show();
					}
				}
				return false;
			}

			@Override
			public WebResourceResponse shouldInterceptRequest(WebView view,
					String url) {
				Log.i("QUERY URL: ", url);
				if (url.contains("http://thwaites.jpl.nasa.gov/fastcgi/visl-solve.py?callback")) {
					new AlertDialog.Builder(ISSMWebActivity.this)
							.setTitle("Yes!")
							.setMessage("Caught server request sucessfully.")
							.setCancelable(false)
							.setPositiveButton("Okay",
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog, int id) {

										}
									}).show();

				}
				// temporary created to avoid compile error. This will cause app
				// to crash at one point during runtime
				return null;

			}
		});
		myWebView.getSettings().setJavaScriptEnabled(true);
		myWebView.getSettings().setLoadWithOverviewMode(true);
		myWebView.getSettings().setUseWideViewPort(true);
		if (MODE == 0) {
			myWebView.loadUrl(srcPath);
		} else {
			issmFolder = getIntent().getExtras().getString("pathToFile");
			myWebView.loadUrl(offPath);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.issmweb_online, menu);
		return true;
	}

	@Override
	public void onBackPressed() {
		if (MODE == 0) {
			if (myWebView.canGoBack()
					&& !myWebView.getOriginalUrl().equals(srcPath)) {
				myWebView.goBack();
			} else {
				showAlertBuilder();
			}
		} else {
			if (myWebView.canGoBack()
					&& !myWebView.getOriginalUrl().equals(offPath)) {
				myWebView.goBack();
			} else {
				showAlertBuilder();
			}
		}
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.refresh:
			myWebView.loadUrl(myWebView.getOriginalUrl());
			break;
		default:
			break;
		}

		return true;
	}

	private void showAlertBuilder() {
		new AlertDialog.Builder(this)
				.setMessage("Are you sure you want to exit?")
				.setCancelable(false)
				.setPositiveButton("Yes",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog, int id) {
								ISSMWebActivity.this.finish();
							}
						}).setNegativeButton("No", null).show();
	}
}
