md=triangle(model(),'../Exp/SquareHole.exp','../Exp/Rifts.exp',50000.);
md=meshprocessrifts(md,'../Exp/Square.exp');
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf2.par');
md.damage.D=0.5*ones(md.mesh.numberofvertices,1);
md=setflowequation(md,'SSA','all');

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,StressbalanceSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure'};
field_tolerances={5.0e-8,2.0e-8,2.0e-8,1e-11};
field_values={...
	   (md.results.StressbalanceSolution.Vx),...
	   (md.results.StressbalanceSolution.Vy),...
	   (md.results.StressbalanceSolution.Vel),...
	   (md.results.StressbalanceSolution.Pressure),...
	   };
