
try:
	import pylab as p
	import matplotlib as mpl
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

def plot_unit(x,y,z,elements,data,is2d,isplanet,datatype,options):
   """
   PLOT_UNIT - unit plot, display data
   
   	Usage:
   		plot_unit(x,y,z,elements,data,is2d,isplanet,datatype,options)
   
   	See also: PLOTMODEL, PLOT_MANAGER
   """

   #edgecolor
   edgecolor=options.getfieldvalue('edgecolor','None')
   
   #number of colorlevels for plots
   colorlevels=options.getfieldvalue('colorlevels',256)
   
   #colormap
   cmap=options.getfieldvalue('colormap',mpl.cm.gnuplot2)
   cbar_extend=0
   if options.exist('cmap_set_over'):
      over=options.getfieldvalue('cmap_set_over','0.5')
      cmap.set_over(over)
      cbar_extend+=1
   if options.exist('cmap_set_under'):
      under=options.getfieldvalue('cmap_set_under','0.5')
      cmap.set_under(under)
      cbar_extend+=1

   #normalize colormap if clim/caxis specified
   if options.exist('clim'):
      lims=options.getfieldvalue('clim',[min(data),max(data)])
   elif options.exist('caxis'):
      lims=options.getfieldvalue('caxis',[min(data),max(data)])
   else:
      lims=[min(data),max(data)]
   norm = mpl.colors.Normalize(vmin=lims[0], vmax=lims[1])
   if datatype==1:
      #element plot
   	if is2d:
   		p.tripcolor(x,y,elements,data,colorlevels,edgecolors=edgecolor)
   	else:
   		raise ValueError('plot_unit error: 3D element plot not supported yet')
   	return
   
   elif datatype==2:
   	#node plot
   	if is2d:
   		p.tricontourf(x,y,elements,data,colorlevels,cmap=cmap,norm=norm)
   		if edgecolor != 'None':
   			p.triplot(x,y,elements,color=edgecolor)
   	else:
   		raise ValueError('plot_unit error: 3D node plot not supported yet')
   	return
   
   elif datatype==3:
   	print 'plot_unit message: quiver plot not implemented yet'
   	return
   
   elif datatype==4:
   	#P1 patch plot
   	print 'plot_unit message: P1 patch plot not implemented yet'
   	return
   
   elif datatype==5:
   	print 'plot_unit message: P0 patch plot not implemented yet'
   	return
   
   else:
		raise ValueError('datatype=%d not supported' % datatype)
