/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateConstraintsDiagnosticHoriz"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"


void	CreateConstraintsDiagnosticHoriz(DataSet** pconstraints, Model* model,ConstDataHandle model_handle){


	int i,j;
	int count;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;
	Rgb*    rgb  = NULL;

	/*spc intermediary data: */
	int spc_sid;
	int spc_node;
	int spc_dof;
	double spc_value;

	/*rgb constructor data: */
	int rgb_id;
	int rgb_dof;
	int rgb_nodeid1;
	int rgb_nodeid2;
	int grid1,grid2;
	
	double* spcvelocity=NULL;
	double* gridonhutter=NULL;
	
	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!model->ismacayealpattyn)goto cleanup_and_return;

	/*Fetch data: */
	ModelFetchData((void**)&spcvelocity,NULL,NULL,model_handle,"spcvelocity","Matrix","Mat");
	ModelFetchData((void**)&gridonhutter,NULL,NULL,model_handle,"gridonhutter","Matrix","Mat");

	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<model->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((model->my_grids[i]==1)){
	#endif

		if ((int)spcvelocity[6*i+0] | (int)gridonhutter[i]){
	
			/*This grid needs to be spc'd to vx_obs:*/

			spc_sid=count;
			spc_node=i+1;
			spc_dof=1; //we enforce first x translation degree of freedom
			spc_value=*(spcvelocity+6*i+3)/model->yts;

			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;
		}

		if ((int)spcvelocity[6*i+1] | (int)gridonhutter[i]){

			/*This grid needs to be spc'd to vy_obs:*/

			spc_sid=count;
			spc_node=i+1;
			spc_dof=2; //we enforce first y translation degree of freedom
			spc_value=*(spcvelocity+6*i+4)/model->yts;
			
			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;
		}

	#ifdef _PARALLEL_
	} //if((my_grids[i]==1))
	#endif
	}

	/*Create penalties loads for linking of collapsed formulation grids with non collapsed grids: */

	/*First fetch penalties: */
	if (strcmp(model->meshtype,"3d")==0){
		ModelFetchData((void**)&model->penalties,&model->numpenalties,NULL,model_handle,"penalties","Matrix","Mat");
	}

	count=0;
	if(model->numpenalties){

		/*First deal with internal grids: */
		for (i=0;i<model->numpenalties;i++){
			if (model->penaltypartitioning[i]>=0){ //this penalty belongs to at least this CPU

				for(j=1;j<model->numlayers;j++){
					/*We are pairing grids along a vertical profile.*/
					grid1=(int)*(model->penalties+model->numlayers*i);
					grid2=(int)*(model->penalties+model->numlayers*i+j);

					rgb_id=count+1; //matlab indexing
					rgb_dof=1;
					rgb_nodeid1=grid1;
					rgb_nodeid2=grid2;
					rgb= new Rgb(rgb_id,rgb_nodeid1,rgb_nodeid2,rgb_dof);
					constraints->AddObject(rgb);
					count++;

					rgb_id=count+1; //matlab indexing
					rgb_dof=2;
					rgb_nodeid1=grid1;
					rgb_nodeid2=grid2;
					rgb= new Rgb(rgb_id,rgb_nodeid1,rgb_nodeid2,rgb_dof);
					constraints->AddObject(rgb);
					count++;
				} //for ( i=0; i<numpenalties; i++) 
			}
		}
	}

	/*Free data: */
	xfree((void**)&model->penalties);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();
	
	/*Free data: */
	xfree((void**)&spcvelocity);
	xfree((void**)&gridonhutter);
	
	cleanup_and_return:
	/*Assign output pointer: */
	*pconstraints=constraints;
}
