/*!\file: numerics.h
 * \brief prototypes for numerics.h
 */ 

#ifndef _NUMERICS_H_
#define  _NUMERICS_H_

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Verbosity.h"
#include "./GaussPoints.h"
#include "./isnan.h"
#include "./recast.h"
#include "./types.h"
#include "./constants.h"
#include "./OptArgs.h"
#include "./OptPars.h"

IssmDouble  min(IssmDouble a,IssmDouble b);
IssmDouble  max(IssmDouble a,IssmDouble b);

#ifdef _HAVE_ADOLC_
IssmPDouble  min(IssmPDouble a,IssmPDouble b);
IssmPDouble  max(IssmPDouble a,IssmPDouble b);
#endif

int         min(int a,int b);
int         max(int a,int b);
IssmDouble  OptFunc(IssmDouble scalar, OptArgs *optargs);
void        BrentSearch(IssmDouble *psearch_scalar,IssmDouble*pJ,OptPars*optpars,IssmDouble (*f)(IssmDouble,OptArgs*), OptArgs*optargs);
void        OptimalSearch(IssmDouble *psearch_scalar,IssmDouble*pJ,OptPars*optpars,IssmDouble (*f)(IssmDouble,OptArgs*), OptArgs*optargs);
void        cross(IssmDouble *result,IssmDouble*vector1,IssmDouble*vector2);
void        XZvectorsToCoordinateSystem(IssmDouble *T,IssmDouble*xzvectors);
int         cubic(IssmDouble a, IssmDouble b, IssmDouble c, IssmDouble d, double X[3], int *num);

int         NewtonSolveDnorm(IssmDouble* pdnorm,IssmDouble c1,IssmDouble c2,IssmDouble c3,IssmDouble n,IssmDouble dnorm);

#endif //ifndef _NUMERICS_H_
