package gov.nasa.jpl.issm;

import java.net.URI;

import android.os.Bundle;
import android.os.Handler;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.widget.Button;

public class ISSMWebActivity extends Activity {

	// URL of the index page of the ISSM web application
	private String srcPath = "++";
	private String offPath = "file:///android_asset/externalicelab/index.html";
	private final String KEY = "mode";
	private String issmFolder = "";
	private int MODE;
	// private String srcPath =
	// "http://www.csupomona.edu/~tqnguyen/CIS311/Project3/index.html";
	private WebView myWebView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_issmweb_online);
		getActionBar().setCustomView(R.layout.actionbar_top_web);
		getActionBar().setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
		MODE = getIntent().getExtras().getInt(KEY);

		Button webHome = (Button) findViewById(R.id.web_home);
		webHome.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				if (MODE == 0) {
					myWebView.loadUrl(srcPath);
				} else {
					myWebView.loadUrl(offPath);
				}
			}

		});

		Button webRefresh = (Button) findViewById(R.id.web_refresh);
		webRefresh.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				myWebView.loadUrl(myWebView.getOriginalUrl());
				// Log.i("srcUrl: ", srcPath);
				// Log.i("newUrl: ", myWebView.getOriginalUrl());
			}

		});

		// final ProgressDialog loading = new ProgressDialog(this);
		// loading.setMessage("Loading page...");
		// loading.setCancelable(false);
		// loading.show();

		myWebView = (WebView) findViewById(R.id.issmWeb);
		myWebView.setWebViewClient(new MyWebViewClient() {

			@Override
			public boolean shouldOverrideUrlLoading(WebView view, String url) {
				if (MODE != 0) {
					if (url.startsWith("http")
							&& !url.contains("http://thwaites.jpl.nasa.gov/fastcgi/visl-solve.py?callbacks")) {
						myWebView.setVisibility(View.INVISIBLE);
						new AlertDialog.Builder(ISSMWebActivity.this)
								.setTitle("Error!")
								.setMessage(
										"Option requires online mode. Please exit and enable connection to access the option.")
								.setCancelable(false)
								.setPositiveButton("Okay",
										new DialogInterface.OnClickListener() {
											public void onClick(
													DialogInterface dialog,
													int id) {
												myWebView.loadUrl(offPath);
												new Handler().postDelayed(
														new Runnable() {
															@Override
															public void run() {
																// This method
																// will be
																// executed once
																// the timer is
																// over
																myWebView
																		.setVisibility(View.VISIBLE);
															}
														}, 700);
											}
										}).show();
					}
				}
				return false;
			}

			@Override
			public WebResourceResponse shouldInterceptRequest(WebView view,
					String url) {
				Log.i("QUERY URL: ", url);
				if (url.contains("http://thwaites.jpl.nasa.gov/fastcgi/visl-solve.py?callback")) {
					new AlertDialog.Builder(ISSMWebActivity.this)
							.setTitle("Yes!")
							.setMessage("Caught server request sucessfully.")
							.setCancelable(false)
							.setPositiveButton("Okay",
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog, int id) {

										}
									}).show();

				}
				// temporary created to avoid compile error. This will cause app
				// to crash at one point during runtime
				return null;

				// URI uri = URI.create(url);
				// String scheme = uri.getScheme();
				// // If scheme not http(s), let the default webview manage it
				// if (!"http".equals(scheme) && !"https".equals(scheme)) {
				// return null;
				// }

				// URL url = uri.toURL();
				//
				// if(doCancelRequest(url)) {
				// // Empty response
				// Log.d(TAG, "URL filtered: " + url);
				// return new WebResourceResponse("text/plain", "UTF-8", new
				// EmptyInputStream());
				//
				// } else {
				// Log.d(TAG, "URL: " + url);
				//
				// HttpURLConnection conn = (HttpURLConnection)
				// url.openConnection();
				// conn.setRequestProperty("User-Agent",
				// mSettings.getUserAgentString());
				//
				// // Configure connections
				// configureConnection(conn);
				//
				// String mimeType = conn.getContentType();
				// String encoding = conn.getContentEncoding();
				//
				// if(mimeType != null && mimeType.contains(CONTENT_TYPE_SPLIT))
				// {
				// String[] split = mimeType.split(CONTENT_TYPE_SPLIT);
				// mimeType = split[0];
				//
				// Matcher matcher = CONTENT_TYPE_PATTERN.matcher(split[1]);
				// if(matcher.find()) {
				// encoding = matcher.group(1);
				// }
				// }
				//
				// InputStream is = conn.getInputStream();
				// return new WebResourceResponse(mimeType, encoding, is);
				// return null;
				// }
			}
		});
		myWebView.getSettings().setJavaScriptEnabled(true);
		myWebView.getSettings().setLoadWithOverviewMode(true);
		myWebView.getSettings().setUseWideViewPort(true);
		// myWebView.getSettings().setBuiltInZoomControls(true);
		if (MODE == 0) {
			myWebView.loadUrl(srcPath);
		} else {
			issmFolder = getIntent().getExtras().getString("pathToFile");
			myWebView.loadUrl(offPath);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.issmweb_online, menu);
		return true;
	}

	@Override
	public void onBackPressed() {
		if (MODE == 0) {
			if (myWebView.canGoBack()
					&& !myWebView.getOriginalUrl().equals(srcPath)) {
				myWebView.goBack();
			} else {
				showAlertBuilder();
			}
		} else {
			if (myWebView.canGoBack()
					&& !myWebView.getOriginalUrl().equals(offPath)) {
				myWebView.goBack();
			} else {
				showAlertBuilder();
			}
		}
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.refresh:
			myWebView.loadUrl(myWebView.getOriginalUrl());
			break;
		default:
			break;
		}

		return true;
	}

	private void showAlertBuilder() {
		new AlertDialog.Builder(this)
				.setMessage("Are you sure you want to exit?")
				.setCancelable(false)
				.setPositiveButton("Yes",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog, int id) {
								ISSMWebActivity.this.finish();
							}
						}).setNegativeButton("No", null).show();
	}
}
