function displaydiagnostic(md)
%DISPLAYDIAGNOSTIC - display solution parameters of diagnostic
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaydiagnostic(md)

disp(sprintf('   Diagnostic solution parameters:'));

disp(sprintf('\n      %s','Newton convergence criteria:'));
fielddisplay(md,'eps_res','mechanical equilibrium residue convergence criterion');
fielddisplay(md,'eps_rel','velocity relative convergence criterion, NaN -> not applied');
fielddisplay(md,'eps_abs','velocity absolute convergence criterion, NaN -> not applied');
fielddisplay(md,'viscosity_overshoot','over-shooting constant new=new+C*(new-old)');

disp(sprintf('\n      boundary conditions:'));
fielddisplay(md,'spcvelocity','constraints flag list (first 3 columns) and values [m/yr] (last 3 columns)');
fielddisplay(md,'pressureload','segments on ice front list');

disp(sprintf('\n      %s','Penalties:'));
fielddisplay(md,'penalty_offset','offset used by penalties: penalty = Kmax*10^offset');

disp(sprintf('\n      %s','Memory management:'));
fielddisplay(md,'lowmem','Set to 1 if you are running low on cluster memory');
fielddisplay(md,'sparsity','matrix sparsity. Set to .001 for < 1M dof, .0001 for 5M dof, and .00001 for > 10M dof');
fielddisplay(md,'connectivity','element connectivity');

disp(sprintf('\n      %s','Debugging:'));
fielddisplay(md,'debug','output debug statements when possible yes-> 1, no -> 0. Default is 1');
fielddisplay(md,'element_debug','output debug statements for elementswhen possible yes-> 1, no -> 0. Default is 0');
fielddisplay(md,'element_debugid','if element_debug on, id of element for which to output messages');
