function displaybc(md)
%DISPLAYBC - display of the boundary conditions fileds
%
%   to avoid clobbering display.m with every field from model md, 
%   we create this routine that displays boundary conditions  from model md, 
%   only if requested.
%
%   Usage:
%      displaybc(md)

disp(sprintf('   Boundary conditions:'));

disp(sprintf('\n      geography:'));
fielddisplay(md,'gridonboundary','grid on boundary flags list');
fielddisplay(md,'elementoniceshelf','element on ice shelf flags list');
fielddisplay(md,'gridoniceshelf','grid on ice shelf flags list');
fielddisplay(md,'elementonicesheet','element on ice sheet flags list');
fielddisplay(md,'gridonicesheet','grid on ice sheet flags list');

disp(sprintf('\n      diagnostic:'));
fielddisplay(md,'spcvelocity','constraints flag list (first 3 columns) and values [m/yr] (last 3 columns)');
fielddisplay(md,'pressureload','segments on ice front list');

disp(sprintf('\n      prognostic:'));
fielddisplay(md,'spcthickness','constraints flag list (first column) and values (second column)');
fielddisplay(md,'neumannvalues_prog','values of the Neumann [m/a]');

disp(sprintf('\n      thermal:'));
fielddisplay(md,'spctemperature','constraints flag list (first column) and values (second column)');
fielddisplay(md,'melting','melting rate [m/a]');
