function md=SetIceShelfBC(md,icefrontfile)
%SETICESHELFBC - Create the boundary conditions for diagnostic and thermal models for a  Ice Shelf with Ice Front
%
%   Neumann BC are used on the ice front (an ANRGUS contour around the ice front
%   must be given in input)
%   Dirichlet BC are used elsewhere for diagnostic
%
%   Usage:
%      md=SetIceShelfBC(md,icefrontfile)
%
%   Example:
%      md=SetIceShelfBC(md,'Front.exp');
%
%   See also: SETICESHEETBC, SETMARINEICESHEETBC

%grid on Dirichlet (boundary and ~icefront)
if ~exist(icefrontfile)
	error(['SetIceShelfBC error message: ice front file ' icefrontfile ' not found']);
end
gridinsideicefront=ContourToMesh(md.elements,md.x,md.y,expread(icefrontfile,1),'node',2);
gridonicefront=double(md.gridonboundary & gridinsideicefront);
pos=find(md.gridonboundary & ~gridonicefront);
md.spcvelocity=zeros(md.numberofgrids,6);
md.spcvelocity(pos,1:3)=1;

%Dirichlet Values
if (length(md.vx_obs)==md.numberofgrids & length(md.vy_obs)==md.numberofgrids)
	disp('      boundary conditions for diagnostic model: spc set as observed velocities');
	md.spcvelocity(pos,4:5)=[md.vx_obs(pos) md.vy_obs(pos)]; %zeros for vz
else
	disp('      boundary conditions for diagnostic model: spc set as zero');
end

%segment on Ice Front
pos=find(gridonicefront(md.segments(:,1)) | gridonicefront(md.segments(:,2)));
md.pressureload=md.segments(pos,:);

%Create zeros melting and accumulation if not specified
if isnan(md.accumulation),
	md.accumulation=zeros(md.numberofgrids,1);
	disp('      no accumulation specified: values set as zero');
end
if isnan(md.melting),
	md.melting=zeros(md.numberofgrids,1);
	disp('      no melting specified: values set as zero');
end

displaystring(md.debug,'%s',['      boundary conditions for prognostic model initialization']);
md.spcthickness=zeros(md.numberofgrids,1);

if (length(md.observed_temperature)==md.numberofgrids),
	displaystring(md.debug,'%s',['      boundary conditions for thermal model']);
	md.spctemperature=ones(md.numberofgrids,2); %surface temperature
	md.spctemperature(:,2)=md.observed_temperature; %values of the spcs
	if (length(md.geothermalflux)~=md.numberofgrids),
		md.geothermalflux=zeros(md.numberofgrids,1);
	end
else
	disp('      no thermal boundary conditions created: no observed temperature found');
end
