/*!\file:  PentaRef.h
 * \brief abstract class for handling Penta oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 

#ifndef _PENTAREF_H_
#define _PENTAREF_H_

class Gauss;
class PentaRef{

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;

		PentaRef();
		PentaRef(const int nummodels);
		~PentaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetNodalFunctions(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctions(IssmDouble* basis, Gauss* gauss,int finiteelement);
		void GetNodalFunctionsVelocity(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctionsPressure(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctionsTensor(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesPressure(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,Gauss* gauss);
		void GetNodalFunctionsP1(IssmDouble* l1l6, Gauss* gauss);
		void GetNodalFunctionsMINI(IssmDouble* l1l7, Gauss* gauss);
		void GetNodalFunctionsP1Derivatives(IssmDouble* dh1dh6,IssmDouble* xyz_list, Gauss* gauss);
		void GetNodalFunctionsMINIDerivatives(IssmDouble* dh1dh7,IssmDouble* xyz_list, Gauss* gauss);
		void GetNodalFunctionsP1DerivativesReference(IssmDouble* dl1dl6,Gauss* gauss);
		void GetNodalFunctionsMINIDerivativesReference(IssmDouble* dl1dl7,Gauss* gauss);
		void GetQuadJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobian(IssmDouble* J, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetTriaJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetSegmentJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobianInvert(IssmDouble*  Jinv, IssmDouble* xyz_list,Gauss* gauss);
		void GetLprimeFSSSA(IssmDouble* LprimeFSSSA, IssmDouble* xyz_list, Gauss* gauss);
		void GetInputValue(IssmDouble* pvalue,IssmDouble* plist, Gauss* gauss);
		void GetInputValue(IssmDouble* pvalue,IssmDouble* plist, Gauss* gauss,int finiteelement);
		void GetInputDerivativeValue(IssmDouble* pvalues, IssmDouble* plist,IssmDouble* xyz_list, Gauss* gauss);

		void BasalNodeIndices(int* pnumindices,int** pindices,int finiteelement);
		void SurfaceNodeIndices(int* pnumindices,int** pindices,int finiteelement);
		int  NumberofNodes(void);
		int  NumberofNodes(int finiteelement);
		int  NumberofNodesVelocity(void);
		int  NumberofNodesPressure(void);
		int  VelocityInterpolation(void);
		int  PressureInterpolation(void);
		int  TensorInterpolation(void);
};
#endif
