/*!\file:  AnalysisConfiguration.cpp
 * \brief: return type of analyses, number of analyses 
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void AnalysisConfiguration(int** panalyses,int* pnumanalyses, int solutiontype){

	/*output: */
	int  numanalyses;
	int* analyses=NULL;

	/*Analyses lists*/
	switch(solutiontype){

		case StressbalanceSolutionEnum:
			numanalyses=6;
			analyses=xNew<int>(numanalyses);
			analyses[0]=StressbalanceAnalysisEnum;
			analyses[1]=StressbalanceVerticalAnalysisEnum;
			analyses[2]=StressbalanceSIAAnalysisEnum;
			analyses[3]=L2ProjectionBaseAnalysisEnum;
			analyses[4]=ExtrudeFromBaseAnalysisEnum;
			analyses[5]=DepthAverageAnalysisEnum;
			break;

		case SteadystateSolutionEnum:
			numanalyses=7;
			analyses=xNew<int>(numanalyses);
			analyses[0]=StressbalanceAnalysisEnum;
			analyses[1]=StressbalanceVerticalAnalysisEnum;
			analyses[2]=StressbalanceSIAAnalysisEnum;
			analyses[3]=L2ProjectionBaseAnalysisEnum;
			analyses[4]=EnthalpyAnalysisEnum;
			analyses[5]=ThermalAnalysisEnum;
			analyses[6]=MeltingAnalysisEnum;
			break;

		case ThermalSolutionEnum:
			numanalyses=3;
			analyses=xNew<int>(numanalyses);
			analyses[0]=ThermalAnalysisEnum;
			analyses[1]=MeltingAnalysisEnum;
			analyses[2]=EnthalpyAnalysisEnum;
			break;

		case HydrologySolutionEnum:
			numanalyses=5;
			analyses=xNew<int>(numanalyses);
			analyses[0]=HydrologyShreveAnalysisEnum;
			analyses[1]=HydrologyDCInefficientAnalysisEnum;
			analyses[2]=HydrologyDCEfficientAnalysisEnum;
			analyses[3]=L2ProjectionBaseAnalysisEnum;
			analyses[4]=L2ProjectionEPLAnalysisEnum;
			break;

		case MasstransportSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=MasstransportAnalysisEnum;
			break;

		case BalancethicknessSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=BalancethicknessAnalysisEnum;
			break;

		case BalancethicknessSoftSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=BalancethicknessAnalysisEnum;
			break;

		case BalancevelocitySolutionEnum:
			numanalyses=3;
			analyses=xNew<int>(numanalyses);
			analyses[0]=BalancevelocityAnalysisEnum;
			analyses[1]=SmoothedSurfaceSlopeXAnalysisEnum;
			analyses[2]=SmoothedSurfaceSlopeYAnalysisEnum;
			break;

		case SurfaceSlopeSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=L2ProjectionBaseAnalysisEnum;
			break;

		case BedSlopeSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=L2ProjectionBaseAnalysisEnum;
			break;

		case GiaSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=GiaAnalysisEnum;
			break;
		
		case DamageEvolutionSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=DamageEvolutionAnalysisEnum;
			break;

		case TransientSolutionEnum:
			numanalyses=15;
			analyses=xNew<int>(numanalyses);
			analyses[ 0]=StressbalanceAnalysisEnum;
			analyses[ 1]=StressbalanceVerticalAnalysisEnum;
			analyses[ 2]=StressbalanceSIAAnalysisEnum;
			analyses[ 3]=L2ProjectionBaseAnalysisEnum;
			analyses[ 4]=ThermalAnalysisEnum;
			analyses[ 5]=MeltingAnalysisEnum;
			analyses[ 6]=EnthalpyAnalysisEnum;
			analyses[ 7]=MasstransportAnalysisEnum;
			analyses[ 8]=FreeSurfaceBaseAnalysisEnum;
			analyses[ 9]=FreeSurfaceTopAnalysisEnum;
			analyses[10]=ExtrudeFromBaseAnalysisEnum;
			analyses[11]=ExtrudeFromTopAnalysisEnum;
			analyses[12]=LevelsetAnalysisEnum;
			analyses[13]=ExtrapolationAnalysisEnum;
			analyses[14]=LsfReinitializationAnalysisEnum;
			break;

		default:
			_error_("solution type: " << EnumToStringx(solutiontype) << " not supported yet!");
			break;
	}

	/*Assign output pointers:*/
	if(pnumanalyses) *pnumanalyses=numanalyses;
	if(panalyses)    *panalyses=analyses;
	else              xDelete<int>(analyses);
}
