/*!\file: depthaverage_core.cpp
 * \brief: core of the extrusion solution
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../solutionsequences/solutionsequences.h"
#include "../modules/modules.h"

void depthaverage_core(FemModel* femmodel){

	if(VerboseSolution()) _printf0_("depth averaging...\n");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(DepthAverageAnalysisEnum);
	solutionsequence_linear(femmodel);

}
