function md=SetIceSheetBC(md)
%SETICESHEETBC - Create the boundary conditions for diagnostic and thermal models for an IceSheet with no Ice Front
%
%   Usage:
%      md=SetIceSheetBC(md)
%
%   See also: SETICESHELFBC, SETMARINEICESHEETBC

%grid on Dirichlet
pos=find(md.gridonboundary);
md.gridondirichlet_diag=zeros(md.numberofgrids,1);
md.gridondirichlet_diag(pos)=1;

%Dirichlet Values
md.dirichletvalues_diag=zeros(md.numberofgrids,2);
if (length(md.vx_obs)==md.numberofgrids & length(md.vy_obs)==md.numberofgrids)
	disp('      boundary conditions for diagnostic model: spc set as observed velocities');
	md.dirichletvalues_diag=[md.vx_obs md.vy_obs];
else
	disp('      boundary conditions for diagnostic model: spc set as zero');
end

%segment on neumann (Ice Front) -> none
md.segmentonneumann_diag=zeros(0,3);
md.neumannvalues_diag=[];

%Create zeros melting and accumulation if not specified
if isnan(md.accumulation),
	md.accumulation=zeros(md.numberofgrids,1);
	disp('      no accumulation specified: values set as zero');
end
if isnan(md.melting),
	md.melting=zeros(md.numberofgrids,1);
	disp('      no melting specified: values set as zero');
end

displaystring(md.debug,'%s',['      boundary conditions for prognostic model initialization']);
md.gridondirichlet_prog=zeros(md.numberofgrids,1);
md.dirichletvalues_prog=zeros(md.numberofgrids,1);
md.segmentonneumann_prog=[];
md.neumannvalues_prog=[];

if (length(md.observed_temperature)==md.numberofgrids),
	displaystring(md.debug,'%s',['      boundary conditions for thermal model']);
	md.gridondirichlet_thermal=ones(md.numberofgrids,1); %surface temperature
	md.dirichletvalues_thermal=md.observed_temperature;
	if (length(md.geothermalflux)~=md.numberofgrids),
		md.geothermalflux=50*10^-3*ones(md.numberofgrids,1); %50 mW/m^2
	end
else
	disp('      no thermal boundary conditions created: no observed temperature found');
end
