function plot_quiver(x,y,u,v,options_structure),
%PLOT_QUIVER - quiver plot with colors
%
%   to be perfected tomorrow
%
%   Usage:
%      plot_quiver(x,y,u,v,options_structure)
%
%   Example:
%      plot_quiver(md.x,md.y,md.vx,md.vy,options_structure);

%get norm Min and Max
Norm=sqrt(u.^2+v.^2);
Min=min(Norm);
Max=max(Norm);

%process options: scaling factor?
if isnan(options_structure.scaling),
	arrow=0.40;
elseif isnumeric(options_structure.scaling),
	arrow=options_structure.scaling;
elseif ischar(options_structure.scaling) & strcmpi(options_structure.scaling,'off'),
	arrow=NaN;
else
	error('plot_quiver error message: scaling option other than scalaer or ''off'' not supported yet')
end

%number of colors?
if isnumeric(options_structure.colorlevels),
	if isnan(options_structure.colorlevels),
		numcolors=30;
	else
		numcolors=options_structure.colorlevels;
	end
	levels=round_ice(linspace(Min,Max,numcolors+1),2);
else
	levels=zeros(1,length(options_structure.colorlevels)+2);
	levels(1)=Min;
	for i=1:length(options_structure.colorlevels)
		levels(i+1)=options_structure.colorlevels{i};
	end
	levels(end)=Max;
	levels=sort(unique(levels));
	numcolors=length(levels)-1;
end

%set the colormap 
if numcolors==2;
	%blue and red
	c=colormap([0 0 1;1 0 0]);
elseif numcolors==3,
	%blue yellow and red
	c=colormap([0 0 1;1 1 0;1 0 0]);
else
	%let jet choose
	c=colormap(jet(numcolors));
end

%Scale data
if ~isnan(arrow),
	delta=((min(x)-max(x))^2+(min(y)-max(y))^2)/numel(x);
	u=arrow*sqrt(delta)*u./Norm;
	v=arrow*sqrt(delta)*v./Norm;
end

%loop over the number of colors
hold on
h=[];
for i=1:numcolors
	pos=find( (Norm>=levels(i)) & (Norm<=levels(i+1)) );
	hprime=quiver(x(pos),y(pos),u(pos),v(pos),'Color',c(i,:),'ShowArrowHead','on','AutoScale','off');
	h=[h;hprime];
end

%take care of colorbar
if  ~strcmpi(options_structure.colorbar,'off'),

	%build ticks
	hcb=colorbar('peer',gca,'location','EastOutside');
	ticklabel=cell(1,length(levels));
	for i=1:length(levels),
		ticklabel{i}=num2str(levels(i));
	end
	tickpos=1:numcolors+1;

	%remove ticks if to many have been created
	proportion=round(length(levels)/10);
	if proportion>1,
		ticklabel=ticklabel(1:proportion:end);
		tickpos=tickpos(1:proportion:end);
	end

	%draw colorbar
	set(hcb,'YTickLabel',ticklabel,'YTick',tickpos);
	%position
	if ~isnan(options_structure.colorbarpos),
		set(hcb,'Position',options_structure.colorbarpos);
	end
	%fontsize
	if ~isnan(options_structure.fontsize),
		fontsize=options_structure.fontsize;
	else
		fontsize=14;
	end
	set(hcb,'FontSize',fontsize);
end
