md=triangle(model(),'../Exp/Square.exp',100000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.py');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);

% parameters
md.transient.isstressbalance=1;
md.transient.ismasstransport=1;
md.transient.isthermal=0;
md.transient.isgroundingline=0;
md.transient.isgia=0;
md.transient.islevelset=1;

% init levelset function
xmin, xmax=min(md.mesh.x), max(md.mesh.x)
ymin, ymax=min(md.mesh.y), max(md.mesh.y)
xmed, ymed=(xmax+xmin)/2.,(ymax+ymin)/2.  

md.mask.ice_levelset=md.mesh.y - ymed

md=solve(md,TransientSolutionEnum())

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure','Thickness','Surface','MaskIceLevelset'}
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,\
		1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,\
		1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13}
field_values={\
	md.results.TransientSolution[0].Vx,\
	md.results.TransientSolution[0].Vy,\
	md.results.TransientSolution[0].Vel,\
	md.results.TransientSolution[0].Pressure,\
	md.results.TransientSolution[0].Thickness,\
	md.results.TransientSolution[0].Surface,\
	md.results.TransientSolution[0].MaskIceLevelset,\
	md.results.TransientSolution[1].Vx,\
	md.results.TransientSolution[1].Vy,\
	md.results.TransientSolution[1].Vel,\
	md.results.TransientSolution[1].Pressure,\
	md.results.TransientSolution[1].Thickness,\
	md.results.TransientSolution[1].Surface,\
	md.results.TransientSolution[1].MaskIceLevelset,\
	md.results.TransientSolution[2].Vx,\
	md.results.TransientSolution[2].Vy,\
	md.results.TransientSolution[2].Vel,\
	md.results.TransientSolution[2].Pressure,\
	md.results.TransientSolution[2].Thickness,\
	md.results.TransientSolution[2].Surface,\
	md.results.TransientSolution[2].MaskIceLevelset,\
	}
