package gov.nasa.jpl.issm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

public class ImageList {
	private static ArrayList<Bitmap> imageList;
	private static ArrayList<Bitmap> largeImageList;
	private static ArrayList<Bitmap> imageListFromURL;
	private Context context;
	final int nImage = 17;

	// ----------------------------------------------------------
	public ImageList(Context context) {
		imageList = new ArrayList<Bitmap>();
		largeImageList = new ArrayList<Bitmap>();
		imageListFromURL = new ArrayList<Bitmap>();
		this.context = context;
	}

	// ----------------------------------------------------------
	public void decodeAndResizeImageFromURL() {
		URL url;
		for (int i = 0; i < 1; i++) {
			try {
				url = new URL(ImageListFromUrl.imageUrls[0]);
				URLConnection connection = url.openConnection();
				HttpURLConnection httpConnection = (HttpURLConnection) connection;
				httpConnection.setRequestMethod("GET");
				httpConnection.connect();

				if (httpConnection.getResponseCode() == HttpURLConnection.HTTP_OK) {
					imageList.add(ImageResizer.decodeSampledBitmapFromURL(url,
							50, 50));
				}
			} catch (IOException e) {
				Log.e("ImageResizer", "Could not load Bitmap from: "
						+ ImageListFromUrl.imageUrls[i]);
			}
		}
	}

	// ----------------------------------------------------------
	public void decodeAndResizeImage() {
		int resID;
		InputStream is = null;
		for (int i = 0; i < nImage; i++) {
			// asset implementation
			try {
				is = new BufferedInputStream(context.getResources().getAssets()
						.open("image" + i + ".png"));
				imageList.add(ImageResizer.decodeSampledBitmapFromAsset(is, 50,
						50));
				// is.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			// resource implementation
			// resID = context.getResources().getIdentifier("image" + i,
			// "drawable", context.getPackageName());
			// imageList.add(ImageResizer.decodeSampledBitmapFromResource(
			// context.getResources(), resID, 50, 50));
			System.gc();
		}
	}

	// ------------------------------------------------------------------------
	// This method is use to pre-load all the large images into a Bitmap
	// ArrayList
	public void decodeLargeImage() {
		int width = (int) (context.getResources().getDisplayMetrics().widthPixels);
		int height = (int) (context.getResources().getDisplayMetrics().heightPixels);
		InputStream is = null;
		for (int i = 0; i < nImage; i++) {
			// asset implementation
			try {
				is = new BufferedInputStream(context.getResources().getAssets()
						.open("image" + i + ".png"));
				largeImageList.add(ImageResizer.decodeSampledBitmapFromAsset(
						is, width, height));
				// is.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			System.gc();
		}
	}

	// public void decodeAndResizeImage() {
	// AssetManager assets = context.getAssets();
	// InputStream is = null;
	// for (int i = 0; i < nImage; i++) {
	// try {
	// is = new BufferedInputStream(assets.open("image" + i + ".png"));
	// } catch (IOException e) {
	// // TODO Auto-generated catch block
	// e.printStackTrace();
	// }
	// imageList.add(ImageResizer.decodeSampledBitmapFromAsset(is, 50, 50));
	// }
	// }

	// ----------------------------------------------------------
	public static ArrayList<Bitmap> getImageList() {
		return imageList;
	}

	// ----------------------------------------------------------
	public static ArrayList<Bitmap> getImageListFromURL() {
		return imageListFromURL;
	}

	public static ArrayList<Bitmap> getLargeImages() {
		return largeImageList;
	}
}
