package gov.nasa.jpl.issm;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
//import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import android.widget.Button;
import gov.nasa.jpl.issm.MyWebViewClient;

public class TeamActivity extends BaseActivity {

	String SrcPath = "http://issm.jpl.nasa.gov/about/";

	private WebView myWebView;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.teampage);
		transition();
		final ProgressDialog loading = new ProgressDialog(this);
		loading.setMessage("Loading page...");
		loading.setCancelable(false);
		final ConnectivityManager conMgr = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
		if (conMgr.getNetworkInfo(0).getState() == NetworkInfo.State.CONNECTED
				|| conMgr.getNetworkInfo(1).getState() == NetworkInfo.State.CONNECTED) {
			loading.show();
		}
		// else if (conMgr.getNetworkInfo(0).getState() ==
		// NetworkInfo.State.DISCONNECTED
		// || conMgr.getNetworkInfo(1).getState() ==
		// NetworkInfo.State.DISCONNECTED) {
		// }

		// Go back to the main menu
		Button homeTab = (Button) findViewById(R.id.play_tab);
		homeTab.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				Intent i = new Intent(TeamActivity.this, MenuPage.class);
				startActivity(i);
				finish();
			}
		});
		// navigate to youtube video
		Button video = (Button) findViewById(R.id.video_tab);
		video.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				// String url = "http://www.youtube.com/watch?v=KlDO0C8r_ws";
				// Intent i = new Intent(Intent.ACTION_VIEW);
				// i.setData(Uri.parse(url));
				Intent i = new Intent(TeamActivity.this, VideoActivity.class);
				startActivity(i);
				finish();
			}
		});
		// pop up a text box that contains information about ISSM
		final Button intro = (Button) findViewById(R.id.about_tab);
		intro.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				// LayoutInflater layoutInflater =
				// (LayoutInflater)getBaseContext().getSystemService(LAYOUT_INFLATER_SERVICE);
				// View popupView = layoutInflater.inflate(R.layout.popuptext,
				// null);
				// final PopupWindow popupWindow = new PopupWindow( popupView,
				// 400,600, true);
				// popupWindow.showAtLocation(popupView, Gravity.CENTER, 0, 0);
				// Button dismiss =
				// (Button)popupView.findViewById(R.id.dismiss);
				// dismiss.setOnClickListener(new Button.OnClickListener()
				// {
				// public void onClick(View v)
				// {
				// popupWindow.dismiss();
				// }
				// });
				Intent i = new Intent(TeamActivity.this, AboutActivity.class);
				startActivity(i);
				finish();
			}
		});
		// Show Team Website
		// Button visitus = (Button) findViewById(R.id.team_tab);
		// visitus.setOnClickListener(new View.OnClickListener() {
		// public void onClick(View v) {
		// // String url = "http://issm.jpl.nasa.gov/";
		// // Intent i = new Intent(Intent.ACTION_VIEW);
		// // i.setData(Uri.parse(url));
		// // startActivity(i);
		//
		// Intent i = new Intent(TeamActivity.this, TeamActivity.class);
		// startActivity(i);
		// }
		// });
		// start gallery image
		Button galleryImage = (Button) findViewById(R.id.gallery_tab);
		galleryImage.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				Intent i = new Intent(TeamActivity.this, GalleryImage.class);
				startActivity(i);
				finish();
			}
		});

		// webView = (WebView) findViewById(R.id.teampage);
		myWebView = (WebView) findViewById(R.id.teampage);
		myWebView.setWebViewClient(new MyWebViewClient() {
			@Override
			public boolean shouldOverrideUrlLoading(WebView view, String url) {

				Log.i("srcUrl: ", SrcPath);
				Log.i("newUrl: ", url);
				if (conMgr.getNetworkInfo(0).getState() == NetworkInfo.State.CONNECTED
						|| conMgr.getNetworkInfo(1).getState() == NetworkInfo.State.CONNECTED) {
					loading.show();
				}
				return false;
			}

			@Override
			public void onPageFinished(WebView view, String url) {
				// hide loading
				loading.dismiss();
			}
		});
		myWebView.getSettings().setJavaScriptEnabled(true);
		myWebView.loadUrl(SrcPath);
	}

	// -------------------------------------------------------------------------------------

	@Override
	public void onBackPressed() {
		if (myWebView.canGoBack()) {
			myWebView.goBack();
		} else {
			Intent i = new Intent(TeamActivity.this, MenuPage.class);
			startActivity(i);
			finish();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.team_menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.refresh:
			myWebView.loadUrl(myWebView.getOriginalUrl());
			break;
		default:
			break;
		}

		return true;
	}
}
